<?php $__env->startSection('title'); ?>
<?php echo e(__('messages.Administration')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php echo $__env->make('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages.Settings') => null,
                __('messages.Languages') => 'active',
            ],
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="<?php echo e(request('key_words')); ?>" name="key_words" type="text" class="form-control" placeholder="<?php echo e(__('messages.Name')); ?>" aria-label="Example text with button addon" aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button" id="button-addon1"><?php echo e(__("messages.Search")); ?><i class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <?php $__currentLoopData = $languages_active; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="badge bg-label-success">
                        <?php if($lang->is_default): ?>
                        <i class="fa-solid fa-circle-check  text-success"></i>
                        <?php endif; ?>

                        <?php echo e($lang->name); ?> - <?php echo e($lang->native_name); ?></span>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('messages.Name')); ?></th>
                            <th><?php echo e(__('messages.Status')); ?></th>
                            <th><?php echo e(__('messages.Default')); ?></th>
                            <th><?php echo e(__('messages.Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        ?>
                        <?php echo $__env->make('inc.is_empty_data' , ['var_check_empty'=>$data , 'var_check_empty_rows'=>4], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($skipCount + $i); ?></th>
                                <?php $i++  ?>


                                <td><?php echo e($item->name); ?> - <?php echo e($item->native_name); ?></td>
                                <td>
                                    <?php if(!$item->is_active): ?>
                                        <span class="badge bg-label-danger me-1"><?php echo e(__('messages.In Active')); ?>

                                            <i class="fa-solid fa-circle-xmark"></i></span>
                                    <?php else: ?>
                                        <span style="min-width: 100px" class="badge bg-label-success me-1"><?php echo e(__('messages.Active')); ?><i
                                                style="" class="fa-solid fa-circle-check"></i></span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if(!$item->is_default): ?>
                                            <i class="fa-solid fa-circle-xmark"></i>
                                    <?php else: ?>

                                            <i class="fa-solid fa-circle-check  text-success"></i>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">

                                                <?php if($item->is_active): ?>
                                                <a data-url="<?php echo e(route('admin.settings.languages.active_in_active' , $item->id)); ?>" data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"  data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>"  data-method="post" data-message="<?php echo e(__('messages.Are you sure to deactivate ?')); ?>" class="dropdown-item btn-action" href="javascript:void(0);">
                                                    <i class="fa-solid fa-circle-xmark"></i>  <?php echo e(__('messages.Deactivate')); ?></a>
                                                <?php else: ?>
                                                <a data-url="<?php echo e(route('admin.settings.languages.active_in_active' , $item->id)); ?>" data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"  data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>"  data-method="post" data-message="<?php echo e(__('messages.Are you sure to activate ?')); ?>" class="dropdown-item btn-action" href="javascript:void(0);">
                                                    <i class="fa-solid fa-circle-check"></i>  <?php echo e(__('messages.Activation')); ?></a>
                                                <?php endif; ?>


                                                <?php if(!$item->is_default): ?>
                                                <a data-url="<?php echo e(route('admin.settings.languages.set_default' , $item->id)); ?>" data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"  data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>"  data-method="post" data-message="<?php echo e(__('messages.Set as default')); ?>" class="dropdown-item btn-action" href="javascript:void(0);">
                                                    <i class="fa-solid fa-language"></i> <?php echo e(__('messages.Set as default')); ?></a>
                                                <?php endif; ?>



                                        </div>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="m-3">
                    <?php echo e($data->appends(Request::except(['_token']))->links()); ?>

                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/labadmin/public_html/resources/views/admin/settings/languages.blade.php ENDPATH**/ ?>