<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.General analysis groups')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php echo $__env->make('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages.General analysis groups') => 'active',
            ],
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="<?php echo e(request('key_words')); ?>" name="key_words" type="text" class="form-control"
                                placeholder="<?php echo e(__('messages.Name')); ?>" aria-label="Example text with button addon"
                                aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1"><?php echo e(__('messages.Search')); ?><i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">


                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_group_general_analysis')): ?>
                            <a href="<?php echo e(route('admin.general-analysis-groups.create')); ?>"
                                class="btn btn-outline-primary waves-effect text-primary"><?php echo e(__('messages.ADD NEW ')); ?><i
                                    class="fa-solid fa-circle-plus"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('messages.Name')); ?></th>
                            <th><?php echo e(__('messages.General analysis')); ?></th>
                            <th><?php echo e(__('messages.Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        ?>
                        <?php echo $__env->make('inc.is_empty_data', [
                            'var_check_empty' => $data,
                            'var_check_empty_rows' => 5,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($skipCount + $i); ?></th>
                                <?php $i++  ?>


                                <td><?php echo e($item->name); ?></td>
                                <td>
                                    <ul>
                                        <?php $__currentLoopData = $item->general_analysis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_general_analysis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item_general_analysis->name); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </td>


                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_group_general_analysis')): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.general-analysis-groups.edit', $item->id)); ?>"><i
                                                class="ti ti-pencil "></i><?php echo e(__('messages.Edit')); ?></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_group_general_analysis')): ?>
                                            <a data-url="<?php echo e(route('admin.general-analysis-groups.destroy', $item->id)); ?>"
                                                data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"
                                                data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>" data-method="delete"
                                                data-message="<?php echo e(__('messages.Are you sure to delete? All patient analyzes for this general analysis will be deleted')); ?>"
                                                class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                    class="ti ti-trash "></i> <?php echo e(__('messages.Delete')); ?></a>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="m-3">
                    <?php echo e($data->appends(Request::except(['_token']))->links()); ?>

                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/labadmin/public_html/resources/views/admin/group-general-analysis/index.blade.php ENDPATH**/ ?>