<?php $__env->startSection('title'); ?>
<?php echo e(__('messages.Logs') ."-" . __("messages.Software errors")); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php echo $__env->make('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages.Logs') => null,
                __('messages.Software errors') => 'active',
            ],
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="<?php echo e(request('key_words')); ?>" name="key_words" type="text" class="form-control" placeholder="<?php echo e(__('messages.Task')); ?>" aria-label="Example text with button addon" aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button" id="button-addon1"><?php echo e(__("messages.Search")); ?><i class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">
                        <a data-url="<?php echo e(route("admin.logs.errors.clear")); ?>" data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"  data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>"  data-method="post" data-message="<?php echo e(__('messages.Are you sure you have deleted it permanently ? You cannot undo it')); ?>" class="btn btn-outline-danger waves-effect text-danger btn-action" href="javascript:void(0);"> <?php echo e(__("messages.Clear log")); ?><i class="fa-solid fa-broom"></i></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('messages.Task')); ?></th>
                            <th><?php echo e(__('messages.Error message')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        ?>
                        <?php echo $__env->make('inc.is_empty_data' , ['var_check_empty'=>$data , 'var_check_empty_rows'=>5], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($skipCount + $i); ?></th>
                                <?php $i++  ?>


                                <td><?php echo e($item->function_name); ?></td>
                                <td><?php echo e($item->message); ?></td>


                               

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="m-3">
                    <?php echo e($data->appends(Request::except(['_token']))->links()); ?>

                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/labadmin/public_html/resources/views/admin/logs/catch_log.blade.php ENDPATH**/ ?>