<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages_303.users')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/rateyo/rateyo.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php echo $__env->make('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_303.users') => 'active',
            ],
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="<?php echo e(request('key_words')); ?>" name="key_words" type="text" class="form-control"
                                placeholder="<?php echo e(__('messages.Name or email')); ?>" aria-label="Example text with button addon"
                                aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1"><?php echo e(__('messages.Search')); ?><i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_user')): ?>
                            <a href="<?php echo e(route('admin.users.create')); ?>"
                                class="btn btn-outline-primary waves-effect text-primary"><?php echo e(__('messages.ADD NEW ')); ?><i
                                    class="fa-solid fa-circle-plus"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('messages.Name')); ?></th>
                            <th><?php echo e(__('messages.Email')); ?></th>
                            <th><?php echo e(__('messages_303.mobile')); ?></th>
                            <th>Role</th>
                            <th><?php echo e(__('messages.Status')); ?></th>
                            <th><?php echo e(__('messages.Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        ?>
                        <?php echo $__env->make('inc.is_empty_data', [
                            'var_check_empty' => $data,
                            'var_check_empty_rows' => 8,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($skipCount + $i); ?></th>
                                <?php $i++  ?>


                                <td><?php echo e($item->name); ?></td>
                                <td><?php echo e($item->email); ?></td>
                                <td><?php echo e($item->mobile); ?></td>
                                <td><?php echo e(__('messages.'.$item->type->value )); ?></td>

                                <td>
                                    <?php if($item->is_block): ?>
                                        <span class="badge bg-label-danger me-1"><?php echo e(__('messages.Blocked')); ?><i
                                                class="fa-solid fa-ban"></i></span>
                                    <?php else: ?>
                                        <span class="badge bg-label-primary me-1"><?php echo e(__('messages.Active')); ?><i
                                                style="" class="fa-solid fa-circle-check"></i></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show_users')): ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.users.show', $item->id)); ?>"><i
                                                        class="ti ti-eye "></i><?php echo e(__('messages_301.Show')); ?></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_user')): ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.users.edit', $item->id)); ?>"><i
                                                        class="ti ti-pencil "></i><?php echo e(__('messages.Edit')); ?></a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('block_user')): ?>
                                                <?php if($item->is_block): ?>
                                                    <a data-url="<?php echo e(route('admin.users.unblock', $item->id)); ?>"
                                                        data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"
                                                        data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>" data-method="post"
                                                        data-message="<?php echo e(__('messages.Are you sure to activate the account ?')); ?>"
                                                        class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                            class="fa-solid fa-circle-check"></i>
                                                        <?php echo e(__('messages.Activate the account')); ?></a>
                                                <?php else: ?>
                                                    <a data-url="<?php echo e(route('admin.users.block', $item->id)); ?>"
                                                        data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"
                                                        data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>" data-method="post"
                                                        data-message="<?php echo e(__('messages.Are you sure the account is blocked ?')); ?>"
                                                        class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                            class="fa-solid fa-ban "></i> <?php echo e(__('messages.Account ban')); ?></a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_user')): ?>
                                            <a data-url="<?php echo e(route('admin.users.destroy', $item->id)); ?>"
                                                data-text_btn_confirm="<?php echo e(__('messages.Confirm')); ?>"
                                                data-text_btn_cancel="<?php echo e(__('messages.Cancel')); ?>" data-method="delete"
                                                data-message="<?php echo e(__('messages.Are you sure you deleted the user? It cannot be undone so you can block him instead')); ?>"
                                                class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                    class="fa-solid fa-trash "></i><?php echo e(__('messages.Delete')); ?></a>
                                            <?php endif; ?>



                                        </div>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="m-3">
                    <?php echo e($data->appends(Request::except(['_token']))->links()); ?>

                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/labadmin/public_html/resources/views/admin/users/index.blade.php ENDPATH**/ ?>