<?php

use Illuminate\Http\Request;
use App\Models\GeneralAnalysis;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\KPIController;
use App\Http\Controllers\Api\PgdController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DataController;
use App\Http\Controllers\Api\TaskController;
use App\Http\Controllers\Api\StoreController;
use App\Http\Controllers\Api\PatientController;
use App\Http\Controllers\Api\ProtocolController;
use App\Http\Controllers\Api\AndrologyController;
use App\Http\Controllers\Api\TestGroupController;
use App\Http\Controllers\Api\GeneticLabController;
use App\Http\Controllers\Api\StatisticsController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\StatisticsUserController;
use App\Http\Controllers\Api\AnalysisPatientController;
use App\Http\Controllers\Api\CryopreservationController;
use App\Http\Controllers\Api\QualityManagementController;
use App\Http\Controllers\Api\QualityManagementNotifyController;
use App\Http\Controllers\Api\InputGeneralAnalysis\VariableController;
use App\Http\Controllers\Api\InputGeneralAnalysis\GeneralAnalysisController;

/*
|--------------------------------------------------------------------------
| API    Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



//------------------------- start  auth  ----------------------//
Route::group(['prefix' => 'auth'], function () {
    Route::post('login', [AuthController::class, 'login']);

    Route::group(['middleware' => 'auth:api'], function () {
        Route::post("logout", [AuthController::class, "logout"]);
        Route::get("user-data", [AuthController::class, "user_data"]);
    });
});
//------------------------- end  auth  ----------------------//


Route::group(['middleware' => 'auth:api'], function () {


    Route::group(['prefix' => 'input-general-analysis'], function () {
        Route::group(['prefix' => 'general-analysis'], function () {
            Route::post("create", [GeneralAnalysisController::class, "store"]);
            Route::post("edit", [GeneralAnalysisController::class, "update"]);
            Route::post("delete", [GeneralAnalysisController::class, "delete"]);
            Route::post("soft-delete", [GeneralAnalysisController::class, "soft_delete"]);
            Route::post("/", [GeneralAnalysisController::class, "index"]);
        });

        Route::group(['prefix' => 'variables'], function () {
            Route::post("create", [VariableController::class, "store"]);
            Route::post("edit", [VariableController::class, "update"]);
            Route::post("delete", [VariableController::class, "delete"]);
            Route::post("soft-delete", [VariableController::class, "soft_delete"]);
            Route::post("/", [VariableController::class, "index"]);
        });
    });



    Route::group(['prefix' => 'notifications'], function () {
        Route::get('', [NotificationController::class, 'notifications']);
        Route::post('delete', [NotificationController::class, 'delete']);
        Route::post('delete-all', [NotificationController::class, 'delete_all']);
    });

    //------------------------- start  Patients  ----------------------//
    Route::group(['prefix' => 'patients'], function () {
        Route::post("create", [PatientController::class, "create"]);
        Route::post("{id}/update", [PatientController::class, "update"]);
        Route::post("{id}/delete", [PatientController::class, "destroy"]);
        Route::post("{id}/delete", [PatientController::class, "destroy"]);
        Route::post("files/{id}/delete", [PatientController::class, "destroy_file"]);
        Route::post("/{id}/previous-analysis", [PatientController::class, "previous_analysis"]);
        Route::post("/change-pregenant", [PatientController::class, "change_pregenant"]);
        Route::post("/", [PatientController::class, "index"]);
    });
    //------------------------- end  Patients  ----------------------//



    //------------------------- start  analysis  ----------------------//
    Route::post("booking", [AnalysisPatientController::class, "booking"]);
    Route::post("delete-booking/{id}", [AnalysisPatientController::class, "delete_booking"]);
    Route::group(['prefix' => 'analysis'], function () {
        Route::post("create", [AnalysisPatientController::class, "create"]);
        Route::group(['prefix' => 'general'], function () {
            Route::post("sample-received", [AnalysisPatientController::class, "sample_received"]);
            Route::post("send-report", [AnalysisPatientController::class, "send_report"]);
            Route::post("", [AnalysisPatientController::class, "general"]);
        });




        Route::group(['prefix' => 'test-group'], function () {
            Route::post("/", [TestGroupController::class, "index"]);
            Route::post("step-one-or-step-two", [TestGroupController::class, "step_one_or_step_two"]);
            Route::post("step-three", [TestGroupController::class, "step_three"]);
            Route::post("step-four", [TestGroupController::class, "step_four"]);
            Route::post("step-five", [TestGroupController::class, "step_five"]);
            Route::post("step-six-freezing", [TestGroupController::class, "step_six_freezing"]);
            Route::post("step-six-thawing", [TestGroupController::class, "step_six_thawing"]);
            Route::post("step-seven", [TestGroupController::class, "step_seven"]);
            Route::get("report/{id}/step/{step}", [TestGroupController::class, "report"]);
            Route::post("pages/{step}", [TestGroupController::class, "get_report_by_step"]);
        });
    });
    //------------------------- end  analysis  ----------------------//


    //------------------------- start  cryopreservation  ----------------------//


    Route::group(['prefix' => 'cryopreservation'], function () {
        Route::post("freezing", [CryopreservationController::class, 'freezing']);
        Route::post("thawing", [CryopreservationController::class, 'thawing']);
        Route::post("sperm", [CryopreservationController::class, 'sperm']);
        Route::post("/", [CryopreservationController::class, 'index']);
    });
    //------------------------- end  cryopreservation  ----------------------//



    //------------------------- start  doctor category  ----------------------//


    Route::group(['prefix' => 'doctor-category'], function () {

        Route::group(['prefix' => 'general'], function () {

            Route::group(['prefix' => 'protocols'], function () {
                Route::post("create", [ProtocolController::class, 'create']);
                Route::post("update/{id}", [ProtocolController::class, 'update']);
                Route::post("delete-file", [ProtocolController::class, 'delete_file']);
                Route::get("{id}", [ProtocolController::class, 'show']);
            });

            Route::post("/", [ProtocolController::class, 'index_general']);
        });

        Route::group(['prefix' => 'test-group'], function () {
            Route::get("/history/{patient_id}", [ProtocolController::class, 'history']);
            Route::post("/", [ProtocolController::class, 'index_test_group']);
        });
    });
    //------------------------- end   doctor category  ----------------------//


    //------------------------- start    quality management   ----------------------//

    Route::group(['prefix' => 'quality-management'], function () {
        Route::group(['prefix' => 'create'], function () {
            Route::post("incubator-quality-control-log", [QualityManagementController::class, "incubator_quality_control_log"]);
            Route::post("incubator-quality-control-log-benchtop", [QualityManagementController::class, "incubator_quality_control_log_benchtop"]);
            Route::post("heated-incubator", [QualityManagementController::class, "heated_incubator"]);
            Route::post("workstations-and-laminar-flow-cabinets", [QualityManagementController::class, "workstations_and_laminar_flow_cabinets_create"]);
            Route::post("micromanipulator-and-icsi-station", [QualityManagementController::class, "micromanipulator_and_icsi_station"]);
            Route::post("air-purifiers-device", [QualityManagementController::class, "air_purifiers_device_create"]);
            Route::post("co2-and-n2-cylinder-gas-level-check", [QualityManagementController::class, "co2_and_n2_cylinder_gas_level_check_create"]);
            Route::post("tank-liquid-nitrogen-level-check", [QualityManagementController::class, "tank_liquid_nitrogen_level_check_create"]);
            Route::post("lab-environment", [QualityManagementController::class, "lab_environment"]);
            Route::post("refrigerators-temperature-log", [QualityManagementController::class, "refrigerators_temperature_log"]);
            Route::post("general-lab-cleaning", [QualityManagementController::class, "general_lab_cleaning"]);
        });


        Route::group(['prefix' => 'update'], function () {
            Route::post("workstations-and-laminar-flow-cabinets", [QualityManagementController::class, "workstations_and_laminar_flow_cabinets_update"]);
            Route::post("air-purifiers-device", [QualityManagementController::class, "air_purifiers_device_update"]);
            Route::post("co2-and-n2-cylinder-gas-level-check", [QualityManagementController::class, "co2_and_n2_cylinder_gas_level_check_update"]);
            Route::post("tank-liquid-nitrogen-level-check", [QualityManagementController::class, "tank_liquid_nitrogen_level_check_update"]);
            Route::post("general-lab-cleaning", [QualityManagementController::class, "general_lab_cleaning_update"]);
            Route::post("refrigerators-temperature-log", [QualityManagementController::class, "refrigerators_temperature_log_update"]);
        });

        Route::group(['prefix' => 'data'], function () {

            Route::post("notify", [QualityManagementNotifyController::class, "notify"]);
            Route::get("types", [QualityManagementController::class, "types"]);
            Route::get("devices/{type}", [QualityManagementController::class, "devices"]);
            Route::get("{type}", [QualityManagementController::class, "data"]);
        });
    });
    //------------------------- end    quality management   ----------------------//

    Route::group(['prefix' => 'genetic-lab'], function () {
        Route::post("create", [GeneticLabController::class, "create"]);
        Route::post("update", [GeneticLabController::class, "update"]);
        //  Route::post("delete", [GeneticLabController::class, "delete"]);
        Route::post("delete-report", [GeneticLabController::class, "delete_report"]);
        Route::post("delete-file", [GeneticLabController::class, "delete_file"]);
        Route::post("/", [GeneticLabController::class, "index"]);
    });


    //------------------------- start  data  ----------------------//
    Route::group(['prefix' => 'data'], function () {
        Route::post("patients", [DataController::class, "patients"]);
        Route::get("doctors", [DataController::class, "doctors"]);
        Route::get("users", [DataController::class, "users"]);
        Route::get("general-analysis", [DataController::class, "general_analysis"]);
        Route::get("ovarian-stimulation", [DataController::class, "ovarian_stimulation"]);
        Route::get("ovulation-trigger", [DataController::class, "ovulation_trigger"]);
        Route::get("groups", [DataController::class, "groups"]);
        Route::get("types", [DataController::class, "types"]);
    });
    //------------------------- start  data  ----------------------//


    //------------------------- start  TASKS  ----------------------//
    Route::group(['prefix' => 'tasks'], function () {
        Route::group(['prefix' => 'admin'], function () {
            Route::post("create", [TaskController::class, "create"]);
            Route::post("update/{id}", [TaskController::class, "update"]);
            Route::post("delete/{id}", [TaskController::class, "delete"]);
            Route::post("delete-file", [TaskController::class, "delete_file"]);
            Route::post("/", [TaskController::class, "index"]);
        });

        Route::group(['prefix' => 'user'], function () {
            Route::post("create-or-update-report", [TaskController::class, "create_or_update_report"]);
            Route::post("delete-file-report", [TaskController::class, "delete_file_report"]);
            Route::post("/", [TaskController::class, "index_user"]);
        });
    });

    //------------------------- start  TASKS  ----------------------//



    //------------------------- start  Store  ----------------------//
    Route::group(['prefix' => 'store'], function () {

        Route::post("create", [StoreController::class, "create"]);
        Route::post("update-qty", [StoreController::class, "update_qty"]);
        Route::get("report/{id}", [StoreController::class, "report"]);
        Route::post("/", [StoreController::class, "index"]);
    });

    //------------------------- start  Store  ----------------------//




    //------------------------- start  Andrology  ----------------------//
    Route::group(['prefix' => 'andrology'], function () {

        Route::post("iui", [AndrologyController::class, "iui"]);
        Route::post("sfa", [AndrologyController::class, "sfa"]);
        Route::post("fna", [AndrologyController::class, "fna"]);
        Route::get("details/analysis/{id}/type/{type}", [AndrologyController::class, "show"]);
        Route::post("/", [AndrologyController::class, "index"]);
    });

    //------------------------- start  Andrology  ----------------------//



    //------------------------- start  Andrology  ----------------------//
    Route::group(['prefix' => 'pgd'], function () {


        Route::post("create", [PgdController::class, "store"]);
        Route::post("update", [PgdController::class, "update"]);
        Route::get("/", [PgdController::class, "index"]);
        Route::get("/{id}", [PgdController::class, "show"]);
        Route::post("/{id}", [PgdController::class, "destroy"]);
    });

    //------------------------- start  Andrology  ----------------------//

    Route::get("kpis" , [KPIController::class , "index"]);
    Route::get("home-counts" , [StatisticsController::class , "home_counts"]);
    Route::get("statistics" , [StatisticsController::class , "statistics"]);
    Route::get("statistics/{user}" , [StatisticsUserController::class , "statistics"]);


});
