<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LogController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\TrashedController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\DepartmentController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\ContactUsController as AdminContactUsController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\QuestionController as AdminQuestionController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SubDepartmentController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\GroupGeneralController;
use App\Http\Controllers\Admin\InputGeneralAnalysis\GeneralAnalysisController;
use App\Http\Controllers\Admin\InputGeneralAnalysis\VariableController;
use App\Http\Controllers\Admin\QualityManagementDeviceController;
use App\Http\Controllers\Admin\TypeTestGroupController;

/**
 *  Routes prefix  superadmins
 *
 *  Routes as  superadmins.
 *
 *
 */

Route::group(["prefix" => "admins", "as" => "admins."], function () {
    Route::get("export", [AdminController::class, "export"])->name('export');
    Route::post("{id}/block", [AdminController::class, "block"])->name('block');
    Route::post("{id}/unblock", [AdminController::class, "unblock"])->name('unblock');
});
Route::resource('admins', AdminController::class);


Route::group(["prefix" => "users", "as" => "users."], function () {
    Route::get("export", [UserController::class, "export"])->name('export');
    Route::post("{id}/block", [UserController::class, "block"])->name('block');
    Route::post("{id}/unblock", [UserController::class, "unblock"])->name('unblock');
    Route::get("/{id}/notify", [NotificationController::class, 'user_notify'])->name('create.notify');
    Route::post("/{id}/notify", [NotificationController::class, 'store_notify'])->name('store.notify');
    Route::post("{id}/verify", [UserController::class, "verify"])->name('verify');
    Route::post("{id}/unverify", [UserController::class, "unverify"])->name('unverify');
});

Route::resource('users', UserController::class);

Route::group(["prefix" => "input-general-analysis", "as" => "input-general-analysis."], function () {
    Route::post('variables/soft-delete/{id}', [VariableController::class, 'soft_delete'])->name('variables.soft-delete');
    Route::resource('variables', VariableController::class);
    Route::post('general-analysis/soft-delete/{id}', [GeneralAnalysisController::class, 'soft_delete'])->name('general-analysis.soft-delete');
    Route::resource('general-analysis', GeneralAnalysisController::class);
});




Route::group(["prefix" => "settings", "as" => "settings."], function () {

    Route::group(["prefix" => "languages", "as" => "languages."], function () {
        Route::get("/", [LanguageController::class, "index"])->name('index');
        Route::post("{id}/active-in-active", [LanguageController::class, "active_in_active"])->name('active_in_active');
        Route::post("{id}/set-default", [LanguageController::class, "set_default"])->name('set_default');
    });

    Route::group(["prefix" => "pages", "as" => "pages."], function () {
        Route::get("{page}", [SettingController::class, "index"])->name("index");
        Route::post("update/{group}", [SettingController::class, "update"])->name("update");
    });
});



Route::resource('general-analysis-groups', GroupGeneralController::class);
Route::resource('type-test-group', TypeTestGroupController::class);
Route::resource('devices', QualityManagementDeviceController::class);


Route::group(["prefix" => "logs", "as" => "logs."], function () {
    Route::group(["prefix" => "errors", "as" => "errors."], function () {
        Route::get("/", [LogController::class, "error_log"])->name("log");
        Route::post("clear/", [LogController::class, "clear_error_log"])->name("clear");
    });
});
