@extends('layouts.app')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('inc.breadcrumb' , ['breadcrumb_items'=>[
         __('messages.Home')=>"active",
    ]])


    <div class="row">
        <div class="col-xl-12 mb-4 col-lg-5 col-12">


            @if (date('a') == 'am')
                @if (app()->getLocale() == "ar")
                    صباح الخير يا {{ auth()->user()->name }}
                @else
                    Good morning,  {{ auth()->user()->name }}
                @endif
            @else

                @if (app()->getLocale() == "ar")
                    مساء الخير يا {{ auth()->user()->name }}
                @else
                    Good evening,   {{ auth()->user()->name }}
                @endif

            @endif
            😍


        </div>
        <div class="col-12 mb-4">
            <div class="card h-100">
              <div class="card-header">
                <div class="d-flex justify-content-between mb-3">
                  <h5 class="card-title mb-0">Statistics</h5>
                  {{--  <small class="text-muted">Updated 1 month ago</small>  --}}
                </div>
              </div>
              <div class="card-body">
                <div class="row gy-3">

                  <div class="col-md-4 col-6">
                    <div class="d-flex align-items-center">
                      <div class="badge rounded-pill bg-label-info me-3 p-2">
                        <i class="tf-icons ti ti-bus"></i>
                      </div>
                      <div class="card-info">
                        <h5 class="mb-0">55</h5>
                        <small>Users</small>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4 col-6">
                    <div class="d-flex align-items-center">
                      <div class="badge rounded-pill bg-label-danger me-3 p-2">
                        <i class="menu-icon tf-icons ti ti-users"></i>
                      </div>
                      <div class="card-info">
                        <h5 class="mb-0">55</h5>
                        <small>Users</small>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4 col-6">
                    <div class="d-flex align-items-center">
                      <div class="badge rounded-pill bg-label-success me-3 p-2">
                        <i class="tf-icons ti ti-user"></i>
                      </div>
                      <div class="card-info">
                        <h5 class="mb-0">55</h5>
                        <small>Users</small>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <!-- Website Analytics -->
        <div class="col-lg-6 mb-4">
          <div
            class="swiper-container swiper-container-horizontal swiper swiper-card-advance-bg"
            id="swiper-with-pagination-cards">
            <div class="swiper-wrapper">

                <div class="swiper-slide">
                    <div class="row">
                      <div class="col-12">
                        <h5 class="text-white mb-0 mt-2">Test</h5>
                        {{--  <small>Total 28.5% Conversion Rate</small>  --}}
                      </div>
                      <div class="row">
                        <div class="col-lg-7 col-md-9 col-12 order-2 order-md-1">
                          <h6 class="text-white mt-0 mt-md-3 mb-3">Traffic</h6>
                          <div class="row">
                            <div class="col-6">
                              <ul class="list-unstyled mb-0">
                                <li class="d-flex mb-4 align-items-center">
                                  <p class="mb-0 fw-medium me-2 website-analytics-text-bg">4</p>
                                  <p class="mb-0">Users</p>
                                </li>
                                <li class="d-flex align-items-center mb-2">
                                  <p class="mb-0 fw-medium me-2 website-analytics-text-bg">4</p>
                                  <p class="mb-0">Users</p>
                                </li>
                              </ul>
                            </div>
                            <div class="col-6">
                              <ul class="list-unstyled mb-0">
                                <li class="d-flex mb-4 align-items-center">
                                  <p class="mb-0 fw-medium me-2 website-analytics-text-bg">4</p>
                                  <p class="mb-0">Users</p>
                                </li>
                                <li class="d-flex align-items-center mb-2">
                                  <p class="mb-0 fw-medium me-2 website-analytics-text-bg">5</p>
                                  <p class="mb-0">Users</p>
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                        <div class="col-lg-5 col-md-3 col-12 order-1 order-md-2 my-4 my-md-0 text-center">
                          <img
                            src="{{ asset('assets/img/illustrations/card-website-analytics-1.png') }}"
                            alt="Website Analytics"
                            width="170"
                            class="card-website-analytics-img" />
                        </div>
                      </div>
                    </div>
                  </div>


            </div>
            <div class="swiper-pagination"></div>
          </div>
        </div>

        <!--/ Website Analytics -->

        <!-- Line Area Chart -->
        <div class="col-12 col-md-6 mb-4">
          <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4>Statistics for {{ date('Y') }}</h4>
            </div>
            <div class="card-body">
              <div id="lineAreaChart"></div>
            </div>
          </div>
        </div>
        <!-- /Line Area Chart -->


    </div>

 </div>
@endsection
{{--
@section('script')
<script src="{{ asset('assets/js/charts-apex.js') }}"></script>
<script>


    if (isDarkStyle) {
        cardColor = config.colors_dark.cardColor;
        headingColor = config.colors_dark.headingColor;
        labelColor = config.colors_dark.textMuted;
        legendColor = config.colors_dark.bodyColor;
        borderColor = config.colors_dark.borderColor;
      } else {
        cardColor = config.colors.cardColor;
        headingColor = config.colors.headingColor;
        labelColor = config.colors.textMuted;
        legendColor = config.colors.bodyColor;
        borderColor = config.colors.borderColor;
      }

      const chartColors = {
        column: {
          series1: '#826af9',
          series2: '#d2b0ff',
          bg: '#f8d3ff'
        },
        donut: {
          series1: '#fee802',
          series2: '#3fd0bd',
          series3: '#826bf8',
          series4: '#2b9bf4'
        },
        area: {
          series1: '#29dac7',
          series2: '#60f2ca',
          series3: '#a5f8cd'
        }
      };
  // Line Area Chart
  // --------------------------------------------------------------------
  const areaChartEl = document.querySelector('#lineAreaChart'),
  areaChartConfig = {
    chart: {
      height: 400,
      type: 'area',
      parentHeightOffset: 0,
      toolbar: {
        show: false
      }
    },
    dataLabels: {
      enabled: false
    },
    stroke: {
      show: false,
      curve: 'straight'
    },
    legend: {
      show: true,
      position: 'top',
      horizontalAlign: 'start',
      labels: {
       colors: legendColor,
        useSeriesColors: false
      }
    },
    grid: {
      borderColor: borderColor,
      xaxis: {
        lines: {
          show: true
        }
      }
    },
    colors: [chartColors.area.series3, chartColors.area.series2, chartColors.area.series1],
    series: [
      {
        name: '{{ __("messages_301.Parents") }}',
        data: "{{ $charts['parents_chart'] }}".split(",")
      },
      {
        name: '{{ __("messages_301.Students") }}',
        data: "{{ $charts['students_chart'] }}".split(",")
      },
      {
        name: '{{ __("messages_301.Drivers") }}',
        data: "{{ $charts['drivers_chart'] }}".split(",")
      }
    ],
    xaxis: {
      categories: "{{ $charts['month_year'] }}".split(","),
      axisBorder: {
        show: false
      },
      axisTicks: {
        show: false
      },
      labels: {
        style: {
          colors: labelColor,
          fontSize: '13px'
        }
      }
    },
    yaxis: {
      labels: {
        style: {
          colors: labelColor,
          fontSize: '13px'
        }
      }
    },
    fill: {
      opacity: 1,
      type: 'solid'
    },
    tooltip: {
      shared: false
    }
  };
if (typeof areaChartEl !== undefined && areaChartEl !== null) {
  const areaChart = new ApexCharts(areaChartEl, areaChartConfig);
  areaChart.render();
}

</script>
@endsection --}}
