@extends('layouts.app')
@section('title')
    {{ __('messages_303.users') }}
@endsection
@section('style')
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/rateyo/rateyo.css') }}" />
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_303.users') => 'active',
            ],
        ])


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="{{ request('key_words') }}" name="key_words" type="text" class="form-control"
                                placeholder="{{ __('messages.Name or email') }}" aria-label="Example text with button addon"
                                aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1">{{ __('messages.Search') }}<i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">
                        {{-- <a href="{{ route('admin.users.export') }}"
                            class="btn btn-outline-primary waves-effect text-primary">{{ __('messages.EXPORT XLS') }}<i
                                class="fa-solid fa-file-export"></i></a> --}}
                        @can('create_user')
                            <a href="{{ route('admin.users.create') }}"
                                class="btn btn-outline-primary waves-effect text-primary">{{ __('messages.ADD NEW ') }}<i
                                    class="fa-solid fa-circle-plus"></i></a>
                        @endcan
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('messages.Name') }}</th>
                            <th>{{ __('messages.Email') }}</th>
                            <th>{{ __('messages_303.mobile') }}</th>
                            <th>Role</th>
                            <th>{{ __('messages.Status') }}</th>
                            <th>{{ __('messages.Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        @endphp
                        @include('inc.is_empty_data', [
                            'var_check_empty' => $data,
                            'var_check_empty_rows' => 8,
                        ])

                        @foreach ($data as $item)
                            <tr>
                                <th>{{ $skipCount + $i }}</th>
                                @php $i++  @endphp


                                <td>{{ $item->name }}</td>
                                <td>{{ $item->email }}</td>
                                <td>{{$item->mobile }}</td>
                                <td>{{__('messages.'.$item->type->value )}}</td>

                                <td>
                                    @if ($item->is_block)
                                        <span class="badge bg-label-danger me-1">{{ __('messages.Blocked') }}<i
                                                class="fa-solid fa-ban"></i></span>
                                    @else
                                        <span class="badge bg-label-primary me-1">{{ __('messages.Active') }}<i
                                                style="" class="fa-solid fa-circle-check"></i></span>
                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('show_users')
                                                <a class="dropdown-item"
                                                    href="{{ route('admin.users.show', $item->id) }}"><i
                                                        class="ti ti-eye "></i>{{ __('messages_301.Show') }}</a>
                                            @endcan
                                            @can('edit_user')
                                                <a class="dropdown-item"
                                                    href="{{ route('admin.users.edit', $item->id) }}"><i
                                                        class="ti ti-pencil "></i>{{ __('messages.Edit') }}</a>
                                            @endcan

                                            @can('block_user')
                                                @if ($item->is_block)
                                                    <a data-url="{{ route('admin.users.unblock', $item->id) }}"
                                                        data-text_btn_confirm="{{ __('messages.Confirm') }}"
                                                        data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="post"
                                                        data-message="{{ __('messages.Are you sure to activate the account ?') }}"
                                                        class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                            class="fa-solid fa-circle-check"></i>
                                                        {{ __('messages.Activate the account') }}</a>
                                                @else
                                                    <a data-url="{{ route('admin.users.block', $item->id) }}"
                                                        data-text_btn_confirm="{{ __('messages.Confirm') }}"
                                                        data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="post"
                                                        data-message="{{ __('messages.Are you sure the account is blocked ?') }}"
                                                        class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                            class="fa-solid fa-ban "></i> {{ __('messages.Account ban') }}</a>
                                                @endif
                                            @endcan

                                            @can('delete_user')
                                            <a data-url="{{ route('admin.users.destroy', $item->id) }}"
                                                data-text_btn_confirm="{{ __('messages.Confirm') }}"
                                                data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="delete"
                                                data-message="{{ __('messages.Are you sure you deleted the user? It cannot be undone so you can block him instead') }}"
                                                class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                    class="fa-solid fa-trash "></i>{{ __('messages.Delete') }}</a>
                                            @endcan



                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="m-3">
                    {{ $data->appends(Request::except(['_token']))->links() }}
                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>
@endsection
