@extends('layouts.app')
@section('title')
{{ __('messages_303.users') }} - {{ $item->name }}
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('inc.breadcrumb' , ['breadcrumb_items'=>[
         __("messages.Home")=>route('home'),
         __('messages_303.users')=>route('admin.users.index'),
         $item->name => null,
         __("messages.Edit")=>"active"
    ]])



    <div class="row justify-content-center">
        <!-- Form controls -->
        <div class="col-md-12">
            <!-- Multi Column with Form Separator -->
            <div class="card mb-4">
              <h5 class="card-header">{{ __('messages.User Data') }}</h5>
              <form class="card-body" action="{{ route('admin.users.update' ,  $item->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="d-flex align-items-start align-items-sm-center gap-4">
                        <img src="{{  $item->image ? asset( $item->image )  :  asset('default-images/user-image.png') }}" alt="user-avatar"
                            class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" />
                        <div class="button-wrapper">
                            <label for="upload" class="btn btn-primary me-2 mb-3" tabindex="0">
                                <span class="d-none d-sm-block">{{ __('messages.Upload') }}<i class="ti ti-upload"></i></span>
                                <i class="ti ti-upload d-block d-sm-none"></i>
                                <input type="file" id="upload" name="image"
                                    class="account-file-input @error('image')
                        is-invalid
                      @enderror"
                                    hidden accept="image/png, image/jpeg, image/jpg" />
                            </label>
                            <button type="button" class="btn btn-label-secondary account-image-reset mb-3">
                                <i class="ti ti-refresh-dot d-block d-sm-none"></i>
                                <span class="d-none d-sm-block">{{ __('messages_303.Reset') }}</span>
                            </button>

                            <div class="text-muted"></div>
                            @error('image')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="row g-3">

                  <div class="col-md-6">
                    <label class="form-label" for="multicol-username">{{ __("messages.Name") }}</label>
                    <input type="text" id="multicol-username" class="form-control  @error('name') is-invalid @enderror" name="name"  value="{{ old('name' , $item->name)  }}"  />
                    @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                   @enderror
                  </div>
                  <div class="col-md-6 mb-4">
                    <label class="mb-1">{{ __('messages_301.Select type') }}</label>
                    <select name="type" id="type" class="form-control select2 type">
                        <option value="">--------</option>
                        @foreach (App\Enums\UserRoleEnum::values_not_admin() as  $type)
                        <option @selected($item->type->value == $type) value="{{ $type }}">{{ __('messages.'.$type )}}</option>
                        @endforeach
                    </select>
                </div>
                  <div class="col-md-6">
                    <label class="form-label" for="multicol-email">{{ __("messages.Email") }}</label>
                      <input  type="text" name="email" value="{{ old('email', $item->email) }}"  id="multicol-email" class="form-control  @error('email') is-invalid @enderror" />
                      @error('email')
                      <div class="invalid-feedback">{{ $message }}</div>
                     @enderror
                  </div>
                  <div class="col-md-6">
                    <label class="form-label" for="multicol-mobile">{{ __('messages.Mobile') }}</label>
                      <input  type="text" name="mobile" value="{{ old('mobile' , $item->mobile) }}"  id="multicol-mobile" class="form-control  @error('mobile') is-invalid @enderror" />
                      @error('mobile')
                      <div class="invalid-feedback">{{ $message }}</div>
                     @enderror
                  </div>
                  <div class="col-md-6">
                    <div class="form-password-toggle">
                      <label class="form-label" for="multicol-password">{{ __("messages.Password") }}</label>
                      <div class="input-group input-group-merge">
                        <input type="password" name="password" id="multicol-password" class="form-control @error('password') is-invalid @enderror"  aria-describedby="multicol-password2" />
                        <span class="input-group-text cursor-pointer" id="multicol-password2"><i class="ti ti-eye-off"></i></span>
                      </div>
                      @error('password')
                      <div class="text-danger">{{ $message }}</div>
                     @enderror
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-password-toggle">
                      <label class="form-label" for="multicol-confirm-password">{{ __("messages.Confirm Password") }}</label>
                      <div class="input-group input-group-merge">
                        <input  type="password" name="password_confirmation" id="multicol-confirm-password" class="form-control @error('password_confirmation') is-invalid @enderror"  aria-describedby="multicol-confirm-password2" />
                        <span class="input-group-text cursor-pointer" id="multicol-confirm-password2"><i class="ti ti-eye-off"></i></span>
                      </div>
                      @error('password_confirmation')
                         <div class="text-danger">{{ $message }}</div>
                     @enderror
                    </div>
                  </div>
                </div>
                <hr class="my-4 mx-n4" />

                <div class="pt-4">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                    <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                </div>
              </form>
            </div>
        </div>
    </div>

 </div>
@endsection

@section('script')
    <script src="{{ asset('assets/js/pages-account-settings-account.js') }}"></script>
@endsection

