@extends('layouts.app')
@section('title')
    {{ __('messages.Types of Test Group') }}
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages.Types of Test Group') => 'active',
            ],
        ])


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="{{ request('key_words') }}" name="key_words" type="text" class="form-control"
                                placeholder="{{ __('messages.Name') }}" aria-label="Example text with button addon"
                                aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1">{{ __('messages.Search') }}<i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">


                        @can('create_group_general_analysis')
                            <a href="{{ route('admin.general-analysis-groups.create') }}"
                                class="btn btn-outline-primary waves-effect text-primary">{{ __('messages.ADD NEW ') }}<i
                                    class="fa-solid fa-circle-plus"></i></a>
                        @endcan
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('messages.Name') }}</th>
                            <th>{{ __('messages.Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        @endphp
                        @include('inc.is_empty_data', [
                            'var_check_empty' => $data,
                            'var_check_empty_rows' => 5,
                        ])

                        @foreach ($data as $item)
                            <tr>
                                <th>{{ $skipCount + $i }}</th>
                                @php $i++  @endphp


                                <td>{{ $item->name }}</td>



                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            @can('edit_type_test_group')
                                            <a class="dropdown-item" href="{{ route('admin.type-test-group.edit', $item->id) }}"><i
                                                class="ti ti-pencil "></i>{{ __('messages.Edit') }}</a>
                                            @endcan
                                            @can('delete_type_test_group')
                                            <a data-url="{{ route('admin.type-test-group.destroy', $item->id) }}"
                                                data-text_btn_confirm="{{ __('messages.Confirm') }}"
                                                data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="delete"
                                                data-message="{{ __('messages.Are you sure to delete? All patient analyzes for this general analysis will be deleted') }}"
                                                class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                    class="ti ti-trash "></i> {{ __('messages.Delete') }}</a>
                                            @endcan

                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="m-3">
                    {{ $data->appends(Request::except(['_token']))->links() }}
                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>
@endsection
