
@extends('layouts.app')
@section('title')
{{ __("messages.Types of Test Group") . " " . __("messages.Edit") }}
@endsection
@section('style')
    <style>
        .btn-icon {

padding: 0;
width: 20px;
height: 20px;

}
    </style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('inc.breadcrumb' , ['breadcrumb_items'=>[
         __("messages.Home")=>route('home'),
         __('messages.Types of Test Group')=>route('admin.type-test-group.index'),
         __("messages.Create")=>"active"
    ]])



    <div class="row justify-content-center">
        <!-- Form controls -->
        <div class="col-md-12">
            <!-- Multi Column with Form Separator -->
            <div class="card mb-4">
              <h5 class="card-header">{{ __('messages.Types of Test Group') }}</h5>
              <form class="card-body form_submit_ajax" action="{{ route('admin.type-test-group.update' , $item->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row g-3">

                    <div class="col-md-6">
                        <label class="form-label" for="multicol-username">{{ __("messages.Name") }}</label>
                        <input type="text" id="multicol-username" class="form-control  @error('name') is-invalid @enderror" name="name"  value="{{ old('name'  , $item->name)  }}"  />
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>



                    <hr>

                </div>

                <div class="pt-4">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                    <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                </div>
              </form>
            </div>
        </div>
    </div>

 </div>
@endsection

@section('script')
<script src="{{ asset('assets/js/pages-account-settings-account.js') }}"></script>


@endsection

