@extends('layouts.app')
@section('title')
{{ __('messages_303.Common questions') }}
@endsection
@section('style')
    <style>


    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_303.Common questions') => route('admin.questions.index'),
                __('messages.Edit') => 'active',
            ],
        ])

<div class="row justify-content-center">
    <!-- Form controls -->
    <div class="col-md-12">
        <!-- Multi Column with Form Separator -->
        <div class="card mb-4">
            <h5 class="card-header">{{ __('messages_303.Common questions') }}</h5>
            <form class="card-body" action="{{ route('admin.questions.update',$item->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row g-3">
                    <div class="nav-align-top  mb-4">
                        <ul class="nav nav-tabs" role="tablist">
                            @foreach ($languages as $lang)
                                <li class="nav-item" role="presentation">
                                    <button type="button" class="nav-link {{ $loop->index == 0 ? 'active' : '' }}"
                                        role="tab" data-bs-toggle="tab"
                                        data-bs-target="#navs-{{ $lang->id }}"
                                        aria-controls="navs-{{ $lang->id }}" aria-selected="true">
                                        {{ $lang->native_name }}
                                    </button>
                                </li>
                            @endforeach


                        </ul>
                        <div class="tab-content p-0">
                            @foreach ($languages as $lang)
                                <div class="tab-pane fade {{ $loop->index == 0 ? 'active show' : '' }}  "
                                    id="navs-{{ $lang->id }}" role="tabpanel">
                                    <div class="row">

                                        <div class="col-md-6 mt-3">
                                            <label class="form-label mb-1"
                                                for="question_{{ $lang->code }}">{{ __('messages_303.Question') }}
                                                ({{ $lang->code }})</label>
                                            <input type="text" id="question_{{ $lang->code }}"
                                                data-slug_name="slug_{{ $lang->code }}"
                                                class="form-control input_name  @error('question_' . $lang->code) is-invalid @enderror"
                                                name="question_{{ $lang->code }}"
                                                value="{{ old('question_' . $lang->code , \App\Http\Helpers\HelperTranslate::get_value($item , $lang->code , 'question' )) }}" />
                                            @error('question_' . $lang->code)
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mt-3">
                                            <label class="form-label mb-1"
                                                for="content_{{ $lang->code }}">{{ __('messages_303.Answer') }}
                                                ({{ $lang->code }})</label>
                                            <textarea id="answer_{{ $lang->code }}"
                                                class="form-control editor_style_{{ $lang->code }}  @error('answer_' . $lang->code) is-invalid @enderror"
                                                name="answer_{{ $lang->code }}">{{ old('answer_' . $lang->code , \App\Http\Helpers\HelperTranslate::get_value($item , $lang->code , 'answer' )) }}</textarea>
                                            @error('answer_' . $lang->code)
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>


                </div>



                <div class="pt-4">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                    <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

    </div>
@endsection

@section('script')
    @include('inc.editor')
@endsection
