@extends('layouts.app')
@section('title')
    {{ __('messages_301.Devices') }}
@endsection

@section('style')
<style>
    #select2-type-container{
        width: 315px !important;
    }
</style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Devices') => 'active',
            ],
        ])


        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="p-3 d-flex justify-content-between">
                <div>
                    <form>
                        <div class="input-group">
                            <input value="{{ request('key_words') }}" name="key_words" type="text" class="form-control"
                                placeholder="{{ __('messages.Name') }}" aria-label="Example text with button addon"
                                aria-describedby="button-addon1">
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1">{{ __('messages.Search') }}<i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div >
                    <form>
                        <div class="d-flex justify-content-between">
                            <select name="type" id="type" class="form-control select2 type">
                                <option value="">{{ __("messages_301.Select type") }}</option>
                                @for ($i = 0; $i <= 8; $i++)
                                    <option value="{{ \App\Enums\DeviceTypeEnum::values()[$i] }}"
                                        @selected(old('type',request('type')) == \App\Enums\DeviceTypeEnum::values()[$i])>
                                        {{ \App\Enums\DeviceTypeEnum::format_text(\App\Enums\DeviceTypeEnum::values()[$i]) }}
                                    </option>
                                @endfor
                            </select>
                            <button type="submit" class="btn btn-outline-primary waves-effect" type="button"
                                id="button-addon1">{{ __('messages.Search') }}<i
                                    class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </form>
                </div>
                <div>
                    <div class="btn-group" role="group" aria-label="Basic example">


                        @can('create_device')
                            <a href="{{ route('admin.devices.create') }}"
                                class="btn btn-outline-primary waves-effect text-primary">{{ __('messages.ADD NEW ') }}<i
                                    class="fa-solid fa-circle-plus"></i></a>
                        @endcan
                    </div>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('messages_301.Type') }}</th>
                            <th>{{ __('messages_301.Device name') }}</th>
                            <th>{{ __('messages.Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @php
                            $i = 1;
                            $skipCount = $data->perPage() * $data->currentPage() - $data->perPage();
                        @endphp
                        @include('inc.is_empty_data', [
                            'var_check_empty' => $data,
                            'var_check_empty_rows' => 5,
                        ])

                        @foreach ($data as $item)
                            <tr>
                                <th>{{ $skipCount + $i }}</th>
                                @php $i++  @endphp


                                <td>{{ \App\Enums\DeviceTypeEnum::format_text($item->type) }}</td>
                                <td>{{ $item->name }}</td>


                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>



                                        <div class="dropdown-menu">
                                            @can('edit_device')
                                                <a class="dropdown-item" href="{{ route('admin.devices.edit', $item->id) }}"><i
                                                        class="ti ti-pencil "></i>{{ __('messages.Edit') }}</a>
                                            @endcan
                                            @can('delete_device')
                                                <a data-url="{{ route('admin.devices.destroy', $item->id) }}"
                                                    data-text_btn_confirm="{{ __('messages.Confirm') }}"
                                                    data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="delete"
                                                    data-message="{{ __('messages.Are you sure you want to delete? You cannot undo it') }}"
                                                    class="dropdown-item btn-action" href="javascript:void(0);"><i
                                                        class="ti ti-trash "></i> {{ __('messages.Delete') }}</a>
                                            @endcan

                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="m-3">
                    {{ $data->appends(Request::except(['_token']))->links() }}
                </div>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->

    </div>
@endsection
@section('script')
    <script>
        $('.select2').select2();
    </script>
@endsection
