@extends('layouts.app')
@section('title')
    {{ __('messages_301.Devices') . ' ' . __('messages.Create') }}
@endsection

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Devices') => route('admin.devices.index'),
                __('messages.Edit') => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="col-md-12">
                <!-- Multi Column with Form Separator -->
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('messages_301.Device data') }}</h5>
                    <form class="card-body" action="{{ route('admin.devices.update',$item->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label class="form-label" for="multicol-username">{{ __('messages.Name') }}</label>
                                <input type="text" id="multicol-username"
                                    class="form-control  @error('name') is-invalid @enderror" name="name"
                                    value="{{ old('name',$item->name) }}" />
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="mb-1">{{ __('messages_301.Select type') }}</label>
                                <select name="type" id="type" class="form-control select2 type">
                                    <option value="">--------</option>
                                    @for ($i = 0; $i <= 8; $i++)
                                        <option value="{{ \App\Enums\DeviceTypeEnum::values()[$i] }}" @selected(old('type',$item->type) == \App\Enums\DeviceTypeEnum::values()[$i])>
                                            {{ \App\Enums\DeviceTypeEnum::format_text(\App\Enums\DeviceTypeEnum::values()[$i]) }}
                                        </option>
                                    @endfor
                                </select>
                            </div>
                        </div>

                        <div class="pt-4">
                            <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                            <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/js/pages-account-settings-account.js') }}"></script>
@endsection
