@extends('layouts.app')
@section('title')
    {{ __('messages_301.Products') }}
@endsection
@section('style')
    <link href="{{ asset('assets/vendor/libs/swiper/swiper.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/vendor/css/pages/ui-carousel.css') }}" rel="stylesheet">
    <style>
        .box-img img,
        .video_box-img img,
        .video_box-img video {
            height: 100%;
            width: 100%;
            object-fit: contain;
            /* border: #e6b6b638 1px solid; */
            {{--  border-radius: 20px  --}}
        }

        .box-img,
        .video_box-img {

            height: 165px;
        }
    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Products') => route('admin.products.index'),
                $item->name => 'active',
            ],
        ])



        <div class="row">
            <div class="col-md-12">
                <div class="card mb-3">
                    <div class="card-header pt-1">
                        <ul class="nav nav-tabs card-header-tabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
                                    data-bs-target="#navs-tab-main-data" aria-controls="navs-tab-main-data"
                                    aria-selected="false" tabindex="-1">
                                    {{ __('messages_301.Product data') }}
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button type="button" class="nav-link " role="tab" data-bs-toggle="tab"
                                    data-bs-target="#navs-tab-media" aria-controls="navs-tab-media" aria-selected="true">
                                    {{ __('messages_301.Media') }}
                                </button>
                            </li>


                        </ul>
                    </div>
                    <div class="card-body pt-3">
                        <div class="tab-content p-0">
                            {{-- start main data --}}
                            <div class="tab-pane fade active show" id="navs-tab-main-data" role="tabpanel">
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <div class="d-flex justify-content-end">
                                            @can('edit_product')
                                                <a href="{{ route('admin.products.edit', $item->id) }}"
                                                    class="btn rounded-pill btn-label-primary waves-effect">
                                                    <span class="ti-xs ti ti-pencil  me-1"></span>{{ __('messages.Edit') }}
                                                    {{ __('messages_301.Product') }}
                                                </a>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="card mb-4">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item text-center h5">
                                                    {{ __('messages_301.Product data') }}</li>
                                                <li class="list-group-item">{{ __('messages.Name') }} :
                                                    {{ $item->name }}
                                                </li>
                                                <li class="list-group-item">{{ __('messages_301.Category name') }} :
                                                    {{ $item->department->name }}</li>
                                                <li class="list-group-item">{{ __('messages_301.Sub category name') }} :
                                                    {{ $item->sub_department->name  }}
                                                </li>
                                                <li class="list-group-item">{{ __('messages_301.Short description') }} :
                                                    {{ $item->short_description }}
                                                </li>
                                                <li class="list-group-item">{{ __('messages_301.Price') }} :
                                                    {{ $item->price }}</li>
                                                <li class="list-group-item">{{ __('messages_301.Old price') }} :
                                                    {{ $item->old_price }}</li>

                                                <li class="list-group-item">{{ __('messages_301.Quantity') }} :
                                                    {{ $item->quantity }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="card  added-cards  p-3  mb-3">

                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item text-center h5">
                                                    {{ __('messages_301.Details') }}
                                                </li>

                                                <p class="mb-0">
                                                    {!! $item->details !!}
                                                </p>

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- end main data --}}

                            {{-- start media --}}
                            <div class="tab-pane fade " id="navs-tab-media" role="tabpanel">

                                <div class="row">
                                    <div class="col-12">
                                        <div class="card mb-4">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item text-center h5">
                                                    {{ __('messages_301.Main image') }}
                                                </li>
                                                <div class="box-img">
                                                    <img class="logo-preview" src="{{ asset($item->main_image->image) }}"
                                                        alt="">
                                                </div>
                                            </ul>
                                        </div>
                                    </div>



                                    <div class="col-12">
                                        <div class="card mb-4">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item text-center h5">
                                                    {{ __('messages_301.Image gallery') }}</li>

                                                <div class="row justify-content-center">
                                                    <div class="col-md-6 mb-4">
                                                        <div class="swiper" id="swiper-with-pagination">
                                                            <div class="swiper-wrapper">
                                                                @if (count($item->media))
                                                                    @foreach ($item->media as $img)
                                                                        <div class="swiper-slide"
                                                                            style="background-image: url({{ asset($img->image) }})">
                                                                        </div>
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                            <div class="swiper-pagination"></div>
                                                        </div>
                                                    </div>
                                                </div>



                                            </ul>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            {{-- end media --}}

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/vendor/libs/swiper/swiper.js') }}"></script>
    <script src="{{ asset('assets/js/ui-carousel.js') }}"></script>
@endsection
