@extends('layouts.app')
@section('title')
    {{ __('messages_301.Products') }}
@endsection
@section('style')
    @include('admin.products.inc.style')
    <style>
        .bordered-img {
            border: 5px solid black;
            /* Adjust the color and width as needed */
            border-radius: 5px;
            /* Adjust the radius to match the rounded corners if needed */
        }

        .shadow-img {
            box-shadow: 0 4px 8px rgb(0, 0, 0);
            /* Adjust the offset, blur, and color as needed */
            border-radius: 5px;
            /* Adjust the radius to match the rounded corners if needed */
        }
    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Products') => route('admin.products.index'),
                __('messages.Create') => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="col-md-12">
                <!-- Multi Column with Form Separator -->
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('messages_301.Product data') }}</h5>
                    <form class="card-body" action="{{ route('admin.products.store') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="{{ asset('default-images/product.png') }}" alt="user-avatar"
                                    class="d-block w-px-100 h-px-100 rounded shadow-img" id="uploadedAvatar" />
                                <div class="button-wrapper">
                                    <label for="upload" class="btn btn-primary me-2 mb-3" tabindex="0">
                                        <span class="d-none d-sm-block">{{ __('messages_301.Upload') }}</span>
                                        <i class="ti ti-upload d-block d-sm-none"></i>
                                        <input type="file" id="upload" name="image"
                                            class="account-file-input @error('image')
                                is-invalid
                              @enderror"
                                            hidden accept="image/png, image/jpeg, image/jpg" />
                                    </label>
                                    <button type="button" class="btn btn-label-secondary account-image-reset mb-3">
                                        <i class="ti ti-refresh-dot d-block d-sm-none"></i>
                                        <span class="d-none d-sm-block">{{ __('messages_303.Reset') }}</span>
                                    </button>

                                    <div class="text-muted">Allowed JPG, JPEG or PNG. Max size of 2M</div>
                                    @error('image')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row g-3">
                            <div class="nav-align-top  mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    @foreach ($languages as $lang)
                                        <li class="nav-item" role="presentation">
                                            <button type="button" class="nav-link {{ $loop->index == 0 ? 'active' : '' }}"
                                                role="tab" data-bs-toggle="tab"
                                                data-bs-target="#navs-{{ $lang->id }}"
                                                aria-controls="navs-{{ $lang->id }}" aria-selected="true">
                                                {{ $lang->native_name }}
                                            </button>
                                        </li>
                                    @endforeach


                                </ul>
                                <div class="tab-content p-0">
                                    @foreach ($languages as $lang)
                                        <div class="tab-pane fade {{ $loop->index == 0 ? 'active show' : '' }}  "
                                            id="navs-{{ $lang->id }}" role="tabpanel">
                                            <div class="row">
                                                <div class="col-md-6 mt-3">
                                                    <label class="form-label mb-1"
                                                        for="name_{{ $lang->code }}">{{ __('messages.Name') }} (
                                                        {{ $lang->code }} ) </label>
                                                    <input type="text" id="name_{{ $lang->code }}"
                                                        data-slug_name="slug_{{ $lang->code }}"
                                                        class="form-control input_name  @error('name_' . $lang->code) is-invalid @enderror"
                                                        name="name_{{ $lang->code }}"
                                                        value="{{ old('name_' . $lang->code) }}" />
                                                    @error('name_' . $lang->code)
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6 mt-3">
                                                    <label class="form-label mb-1"
                                                        for="short_description_{{ $lang->code }}">{{ __('messages_301.Short description') }}
                                                        ({{ $lang->code }})
                                                    </label>
                                                    <input type="text" id="short_description_{{ $lang->code }}"
                                                        data-slug_name="slug_{{ $lang->code }}"
                                                        class="form-control input_name  @error('short_description_' . $lang->code) is-invalid @enderror"
                                                        name="short_description_{{ $lang->code }}"
                                                        value="{{ old('short_description_' . $lang->code) }}" />
                                                    @error('short_description_' . $lang->code)
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>

                                                <div class="col-md-12 mt-3">
                                                    <label class="form-label mb-1"
                                                        for="details_{{ $lang->code }}">{{ __('messages_301.Details') }}
                                                        ( {{ $lang->code }} )</label>
                                                    <textarea id="details_{{ $lang->code }}"
                                                        class="form-control editor_style_{{ $lang->code }}  @error('details_' . $lang->code) is-invalid @enderror"
                                                        name="details_{{ $lang->code }}">{{ old('details_' . $lang->code) }}</textarea>
                                                    @error('details_' . $lang->code)
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>

                                            </div>
                                        </div>
                                    @endforeach


                                </div>
                            </div>

                            <div class="col-6 mt-4">
                                <label class="mb-1">{{ __('messages_301.Select categories') }}</label>
                                <select name="department_id" id="select_department_id"
                                    class="form-control select2  @error('department_id') is-invalid @enderror select_department_id">
                                    <option value="">--------</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" @selected(old('department_id') == $category->id)>
                                            {{ $category->name }}</option>
                                    @endforeach
                                </select>
                                @error('department_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            </div>

                            <div class="col-6 mt-4">
                                <label class="mb-1">{{ __('messages_301.Select sub categories') }}</label>
                                <select name="sub_department_id" id="select_sub_department_id"
                                    class="form-control select2  @error('sub_department_id') is-invalid @enderror select_sub_department_id">
                                    <option value="">--------</option>
                                </select>
                                @error('sub_department_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mt-3">
                                <label class="form-label mb-1" for="quantity">{{ __('messages_301.Quantity') }}  </label>
                                <input type="number" id="quantity"
                                    class="form-control   @error('quantity') is-invalid @enderror" name="quantity"
                                    value="{{ old('quantity') }}" />
                                @error('quantity')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mt-3">
                                <label class="form-label mb-1" for="price">{{ __('messages_301.Price') }} </label>
                                <input type="number" id="price" step=".1"
                                    class="form-control   @error('price') is-invalid @enderror" name="price"
                                    value="{{ old('price') }}" />
                                @error('price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mt-3">
                                <label class="form-label mb-1" for="old_price">{{ __('messages_301.Old price') }}</label>
                                <input step=".1" type="number" id="old_price"
                                    class="form-control   @error('old_price') is-invalid @enderror" name="old_price"
                                    value="{{ old('old_price') }}" />
                                @error('old_price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>



                            <hr>
                            <div class="content-header mb-3">
                                <h6 class="mb-0">{{ __('messages_301.Image gallery') }}</h6>
                                <small>{{ __('messages_301.Upload the image you want to the image gallery') }}</small>
                            </div>

                            <div class="col-12">
                                <input type="file" multiple id="inp-images" name="media[]" class="form-control">
                            </div>

                        </div>





                        <div class="pt-4">
                            <button type="submit"
                                class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                            <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/lib/file-input') }}/js/fileinput.min.js"></script>
    <script src="{{ asset('assets/js/pages-account-settings-account.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/toastr/toastr.js') }}"></script>

    @include('admin.products.inc.script_submit')
    @include('inc.editor')
    <script>
        $(document).ready(function() {

            @if (old('department_id'))
                get_sub_categories("{{ old('department_id') }}")
            @endif

            $("#select_department_id").change(function() {
                var department_id = $(this).val();
                get_sub_categories(department_id)
            })



            function get_sub_categories(department_id) {

                var url = "{{ route('admin.get_sub_category') }}?department_id=" + department_id;
                $.ajax({
                    url,
                    success: function(res) {
                        console.log(res)
                        $("#select_sub_department_id").html(res)

                        var old_sub_department_id = "{{ old('sub_department_id') }}";
                        if (old_sub_department_id) {
                            $("#select_sub_department_id").val(old_sub_department_id);
                        }
                    }
                })
            }




        })
    </script>
    <script>
        $(function() {

            $("#inp-images").fileinput({
                theme: "fa",
                // maxFileCount: 10,
                allowedFileTypes: ['image'],

                showCancel: true,
                showRemove: false,
                showUpload: false,
                overwriteInitial: false,

                initialPreviewAsData: true,

            });

            $('.fileinput-remove').
            html('<i class="fa fa-times-circle text-danger"></i>')
                .addClass('rounded p-1 m-1');

            $("#inp-images").on("filepredelete", function(jqXHR) {
                var abort = true;
                if (confirm("Are you sure you want to delete this file?")) {
                    abort = false;
                }
                return abort;
            });
        })
    </script>
@endsection
