@extends('layouts.app')
@section('title')
    {{ __('messages.Articles') }}
@endsection

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages.Articles') => route('admin.posts.index'),
                __('messages_301.Show') => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="container-xxl flex-grow-1 container-p-y">

                    <div class="col-xl-12 col-12">
                        <div class="card mb-4" id="card-block">
                            <h5 class="card-header">{{ $item->title }}</h5>
                            <div class="card-body">
                                <p class="card-text">
                                    {!! $item->content !!}
                                </p>

                                <div class="block-ui-btn demo-inline-spacing">
                                    @foreach ($item->tags as $tag)
                                        <span class="badge bg-label-primary">{{ $tag->name }}</span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- / Content -->

                <!-- Footer -->


            </div>
        </div>

    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/js/app-academy-course-details.js') }}"></script>
@endsection
