<script>
    $(function() {

        $(".input_name").on("change keyup keydown focus", function() {
            var text = $(this).val();
            var slug_name = $(this).data('slug_name');
            var new_text = text.replace(/\s+/g, '-').toLowerCase()
            $(`input[name=${slug_name}]`).val(new_text);

            if (text) {
                $(".prefix_title_word").html(`-${text}`);
            } else {
                $(".prefix_title_word").html(null);
            }

        })

        const TagifyCustomListSuggestionEl = document.querySelector('#TagifyCustomListSuggestion');

        function tagTemplate(tagData) {
            return `
<tag title="${tagData.title || tagData.email}"
contenteditable='false'
spellcheck='false'
tabIndex="-1"
class="${this.settings.classNames.tag} ${tagData.class ? tagData.class : ''}"
${this.getAttributes(tagData)}
>
<x title='' class='tagify__tag__removeBtn' role='button' aria-label='remove tag'></x>
<div>
<div class='tagify__tag__avatar-wrap'>
<img onerror="this.style.visibility='hidden'" src="${tagData.avatar}">
</div>
<span class='tagify__tag-text'>${tagData.name}</span>
</div>
</tag>
`;
        }

        function suggestionItemTemplate(tagData) {
            return `
<div ${this.getAttributes(tagData)}
class='tagify__dropdown__item align-items-center ${tagData.class ? tagData.class : ''}'
tabindex="0"
role="option"
>
${
tagData.avatar
? `<div class='tagify__dropdown__item__avatar-wrap'>
                    <img onerror="this.style.visibility='hidden'" src="${tagData.avatar}">
                  </div>`
: ''
}
<div class="fw-medium">${tagData.name}</div>
<span>${tagData.name}</span>
</div>
`;
        }

        function dropdownHeaderTemplate(suggestions) {
            return `
<div class="${this.settings.classNames.dropdownItem} ${this.settings.classNames.dropdownItem}__addAll">
<strong>${this.value.length ? `Add remaning` : 'Add All'}</strong>
<span>${suggestions.length} members</span>
</div>
`;
        }
        var url = "{{ route('admin.get_all_tags') }}";
        var tagsList = [];

        $.ajax({
            url,
            success: function(res) {
                console.log(res)
                tagsList = res



                let TagifyCustomListSuggestion = new Tagify(TagifyCustomListSuggestionEl, {
                    whitelist: tagsList,
                    // maxTags: 10,
                    dropdown: {
                        // maxItems: 20,
                        classname: '',
                        enabled: 0,
                        closeOnSelect: false
                    }
                });

                TagifyCustomListSuggestion.on('dropdown:select',
                        onSelectSuggestion) // allows selecting all the suggested (whitelist) items
                    .on('edit:start',
                        onEditStart); // show custom text in the tag while in edit-mode

                function onSelectSuggestion(e) {
                    // custom class from "dropdownHeaderTemplate"
                    if (e.detail.elm.classList.contains(
                            `${TagifyCustomListSuggestion.settings.classNames.dropdownItem}__addAll`
                        ))
                        TagifyCustomListSuggestion.dropdown.selectAll();
                }

                function onEditStart({
                    detail: {
                        tag,
                        data
                    }
                }) {
                    TagifyCustomListSuggestion.setTagTextNode(tag, `${data.name}`);
                }

            }
        })

    })
</script>
