@extends('layouts.app')
@section('title')
    {{ __('messages_301.Notifications') }}
@endsection
@section('style')
    <style>
        .bootstrap-select:not([class*=col-]):not([class*=form-control]):not(.input-group-btn) {
            width: 100% !important;
        }
    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Notifications') => route('admin.notifications.create'),
                __('messages.Create') => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="col-md-12">
                <!-- Multi Column with Form Separator -->
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('messages_301.Notification data') }}</h5>
                    <form class="card-body" action="{{ route('admin.notifications.store') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="row g-3">
                            <div class="nav-align-top  mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    @foreach ($languages as $lang)
                                        <li class="nav-item" role="presentation">
                                            <button type="button" class="nav-link {{ $loop->index == 0 ? 'active' : '' }}"
                                                role="tab" data-bs-toggle="tab"
                                                data-bs-target="#navs-{{ $lang->id }}"
                                                aria-controls="navs-{{ $lang->id }}" aria-selected="true">
                                                {{ $lang->native_name }}
                                            </button>
                                        </li>
                                    @endforeach


                                </ul>
                                <div class="tab-content p-0">
                                    @foreach ($languages as $lang)
                                        <div class="tab-pane fade {{ $loop->index == 0 ? 'active show' : '' }}  "
                                            id="navs-{{ $lang->id }}" role="tabpanel">
                                            <div class="row">
                                                <div class="col-md-12 mt-3">
                                                    <label class="form-label mb-1"
                                                        for="message_{{ $lang->code }}">{{ __('messages_301.Message') }}
                                                        ({{ $lang->code }})
                                                    </label>
                                                    <textarea id="message_{{ $lang->code }}" class="form-control   @error('message_' . $lang->code) is-invalid @enderror"
                                                        name="message_{{ $lang->code }}">{{ old('message_' . $lang->code) }}</textarea>
                                                    @error('message_' . $lang->code)
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>


                                            </div>
                                        </div>
                                    @endforeach
                                    <div class="row">
                                        <div class="col-md- mt-3">
                                            <label class="form-label d-block">{{ __('messages_301.Send to') }}</label>
                                            <div class="input-group">
                                                <select name="type"
                                                    class="selectpicker show-tick @error('type') is-invalid @enderror"
                                                    id="selectpickerIcons" data-icon-base="ti" data-tick-icon="ti-check"
                                                    data-style="btn-default" data-live-search="true">
                                                    <option selected disabled>{{ __('messages_301.Select type') }}
                                                    </option>
                                                    <option value="client" @selected(old('type') == 'client')>
                                                        {{ __('messages_301.All clients') }}</option>
                                                    <option value="doctor" @selected(old('type') == 'doctor')>
                                                        {{ __('messages_301.All doctors') }}</option>

                                                    <option value="trainer" @selected(old('type') == 'trainer')>
                                                        {{ __('messages_301.All trainers') }}</option>

                                                    <option value="all" @selected(old('type') == 'all')>
                                                        {{ __('messages_301.For all') }}</option>
                                                </select>

                                                @error('type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>




                                </div>

                            </div>


                        </div>



                        <div class="pt-4">
                            <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                            <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
