@extends('layouts.app')
@section('title')
{{ __("messages.General analysis") . " " . __("messages.Create") }}
@endsection
@section('style')
    <style>
        .btn-icon {

padding: 0;
width: 20px;
height: 20px;

}
    </style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('inc.breadcrumb' , ['breadcrumb_items'=>[
         __("messages.Home")=>route('home'),
         __('messages.General analysis')=>route('admin.input-general-analysis.variables.index'),
         __("messages.Create")=>"active"
    ]])



    <div class="row justify-content-center">
        <!-- Form controls -->
        <div class="col-md-12">
            <!-- Multi Column with Form Separator -->
            <div class="card mb-4">
              <h5 class="card-header">{{ __('messages.General analysis data') }}</h5>
              <form class="card-body form_submit_ajax" action="{{ route('admin.input-general-analysis.general-analysis.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">

                    <div class="col-md-6">
                        <label class="form-label" for="multicol-username">{{ __("messages.Name") }}</label>
                        <input type="text" id="multicol-username" class="form-control  @error('name') is-invalid @enderror" name="name"  value="{{ old('name')  }}"  />
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                   <div class="col-md-6 mb-4">
                        <label for="select2Multiple"
                            class="form-label">{{ __('messages.Variables') }}</label>
                        <select id="select2Multiple" name="variables[]"
                            class="select2 form-select @error('variables')
                            is-invalid
                        @enderror"
                            multiple>
                            <option disabled>{{ __('messages.Select variables') }}</option>
                            @foreach ($variables as  $variable)
                            <option value="{{  $variable->id }}" @selected(old('variables') && in_array($variable->id , old('variables') )) >{{ $variable->name . "  ( DV :  " .  $variable->default_value . " )"}}</option>
                            @endforeach
                        </select>
                        @error('variables')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <hr>
                    <div class="content-header mb-3">
                      <h6 class="mb-0">{{ __('messages.New variables') }}</h6>
                    </div>
                    <div class="repeater">
                      <div class="mb-3 border border-dark rounded p-3" data-repeater-list="other_variables">
                         <div class="" style="display: flex ; justify-content:left">
                          <button data-repeater-create type="button" class="btn rounded-pill btn-label-primary waves-effect">
                              <span class="fa-solid fa-circle-plus  me-1"></span>{{ __('messages.Add new variables') }}
                          </button>
                         </div>
                              <div class="repeater-wrapperpt-md-4 row border border-dark  mx-3 my-4 p-4  rounded " data-repeater-item>
                                  <div class="col-6">
                                      <label class="form-label" for="username">{{ __("messages.Name") }}</label>
                                      <div class="input-group input-group-merge form-send-message">
                                          <input name="name" type="text" class="form-control message-input" placeholder="" aria-describedby="text-to-speech-addon">
                                          <span class="message-actions input-group-text">
                                              <button data-repeater-delete type="button" class="btn rounded-pill btn-icon btn-outline-danger waves-effect">
                                                  <span class="ti ti-x"></span>
                                              </button>
                                          </span>
                                      </div>
                                  </div>
                                  <div class="col-6">
                                      <label class="form-label" for="username">{{ __("messages.Default Value") }}</label>
                                      <div class="input-group input-group-merge form-send-message">
                                          <input type="text" name="default_value" class="form-control message-input" placeholder="" aria-describedby="text-to-speech-addon">
                                          <span class="message-actions input-group-text">
                                              <button data-repeater-delete type="button" class="btn rounded-pill btn-icon btn-outline-danger waves-effect">
                                                  <span class="ti ti-x"></span>
                                              </button>
                                          </span>
                                      </div>
                                  </div>

                              </div>

                        </div>
                    </div>

                </div>

                <div class="pt-4">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                    <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                </div>
              </form>
            </div>
        </div>
    </div>

 </div>
@endsection

@section('script')
<script src="{{ asset('assets/js/pages-account-settings-account.js') }}"></script>
<script src="{{ asset('assets/js/ajax_request.js') }}"></script>
    @include('admin.input-general-analysis.general-analysis.script')

@endsection

