@extends('layouts.app')
@section('title')
    {{ __('messages_301.Coupons') }}
@endsection
@section('style')
    <style>
        .bootstrap-select:not([class*=col-]):not([class*=form-control]):not(.input-group-btn) {
            width: 100% !important;
        }
    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_301.Coupons') => route('admin.coupons.index'),
                __('messages.Create') => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="col-md-12">
                <!-- Multi Column with Form Separator -->
                <div class="card mb-4">
                    <h5 class="card-header pt-2">{{ __('messages_301.Coupon data') }}</h5>

                    <form class="card-body" action="{{ route('admin.coupons.store') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="row g-3">
                            <div class="row g-3">


                                <div class="col-md-6">
                                    <label class="form-label"
                                        for="flatpickr-date">{{ __('messages_301.Start date') }}</label>
                                    <input type="date" id="flatpickr-date"
                                        class="form-control flatpickr-input active  @error('start_date') is-invalid @enderror"
                                        name="start_date" value="{{ old('start_date') }}" />
                                    @error('start_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('messages_301.End date') }}</label>
                                    <input type="date"
                                        class="form-control flatpickr-input active  @error('end_date') is-invalid @enderror"
                                        name="end_date" value="{{ old('end_date') }}" />
                                    @error('end_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"
                                        for="html5-number-input">{{ __('messages_301.Count used') }}</label>
                                    <input type="number" id="html5-number-input"
                                        class="form-control @error('count_used') is-invalid @enderror" name="count_used"
                                        value="{{ old('count_used') }}" />
                                    @error('count_used')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label" for="html5-number-input">{{ __('messages_301.Percentage') }}
                                        %</label>
                                    <input type="number" id="html5-number-input" max="99"
                                        class="form-control @error('percentage') is-invalid @enderror" name="percentage"
                                        value="{{ old('percentage') }}" />
                                    @error('percentage')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="input-group justify-contet-between">
                                    <div class="col-md-4">
                                        <label class="form-label" for="input-code">{{ __('messages_301.Code') }}</label>
                                        <input type="text" id="input-code"
                                            class="form-control @error('code') is-invalid @enderror" name="code"
                                            value="{{ old('code') }}" />
                                        @error('code')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-1">
                                        <div class="input-group-append pt-4">
                                            <button class="btn btn-outline-secondary" id="generate_code" type="button">
                                                <i class="ti ti-refresh"></i>
                                            </button>
                                        </div>
                                    </div>


                                    <div class="col-md-3">
                                        <div class="text-light small fw-medium mb-3">{{ __('messages_301.Activation') }}</div>
                                        <label class="switch">
                                            <input type="checkbox" name="is_active" checked class="switch-input" />
                                            <span class="switch-toggle-slider">
                                                <span class="switch-on"></span>
                                                <span class="switch-off"></span>
                                            </span>
                                            <span class="switch-label">{{ __('messages_301.Activation') }}</span>
                                        </label>
                                    </div>
                                </div>


                            </div>











                            <!-- Form with Tabs -->

                            <div class="pt-4">
                                <button type="submit"
                                    class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                                <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            $('#generate_code').click(function() {
                var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                var code = '';
                for (var i = 0; i < 10; i++) {
                    code += chars.charAt(Math.floor(Math.random() * chars.length));
                }
                $('#input-code').val(code);
            });
        });
    </script>
@endsection
