@extends('layouts.app')
@section('title')
    {{ __('messages_303.contact_us') }}
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                __('messages_303.contact_us') => route('admin.contactus.index'),
                __('messages_303.message') => 'active',
            ],
        ])


        <!-- Basic Bootstrap Table -->
        <div class="card card-action mb-4">
            <div class="card-header align-items-center">
              <h5 class="card-action-title mb-0">{{__('messages_303.message')}}</h5>
              <div class="card-action-element">
                </div>
              </div>
            </div>
            <div class="card-body pb-0">
              <ul class="timeline ms-1 mb-0">
                <li class="timeline-item timeline-item-transparent">
                  <span class="timeline-point timeline-point-primary"></span>
                  <div class="timeline-event">
                    <div class="timeline-header">
                     <h6 class="mb-0">{{ __('messages.Name') }} : {{$data->full_name}}</h6>
                      </div><hr>
                    <div class="timeline-header">
                      <h6 class="mb-0"> {{ __('messages.Email') }} : {{$data->email}}</h6>
                    </div><hr>
                    <h6 class="mb-0"> {{ __('messages_303.subject') }} : {{$data->subject}}</h6>
                  </div><hr>
                  <div class="timeline-event">
                    <p class="mb-2">{{ __('messages_303.comment') }} :   {{$data->comment}}</p>
                  </div> <hr>
                  @can('delete_contact_us_message')
                  <a data-url="{{ route('admin.contactus.delete', $data->id) }}"
                      data-text_btn_confirm="{{ __('messages.Confirm') }}"
                      data-text_btn_cancel="{{ __('messages.Cancel') }}" data-method="delete"
                      data-message="{{ __('messages.Are you sure you want to delete? You cannot undo it') }}"
                      class="btn btn-danger waves-effect waves-light btn-action"
                      href="javascript:void(0);">
                     {{ __('messages_303.clear message') }} <i class="ti ti-trash"></i>
                  </a>
              @endcan


                </li>
              </ul>
            </div>
          </div>
        <!--/ Basic Bootstrap Table -->

    </div>
@endsection
