@extends('layouts.app')
@section('title')
    {{ $title }}
@endsection
@section('style')
    <style>


    </style>
@endsection
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        @include('inc.breadcrumb', [
            'breadcrumb_items' => [
                __('messages.Home') => route('home'),
                $title => route('admin.abouts.index', $type),
                $title => 'active',
            ],
        ])



        <div class="row justify-content-center">
            <!-- Form controls -->
            <div class="col-md-12">
                <!-- Multi Column with Form Separator -->
                <div class="card mb-4">
                    <h5 class="card-header">{{ $title }}</h5>
                    <form class="card-body" action="{{ route('admin.abouts.update', $type) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="row g-3">
                            <div class="nav-align-top  mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    @foreach ($languages as $lang)
                                        <li class="nav-item" role="presentation">
                                            <button type="button" class="nav-link {{ $loop->index == 0 ? 'active' : '' }}"
                                                role="tab" data-bs-toggle="tab"
                                                data-bs-target="#navs-{{ $lang->id }}"
                                                aria-controls="navs-{{ $lang->id }}" aria-selected="true">
                                                {{ $lang->native_name }}
                                            </button>
                                        </li>
                                    @endforeach


                                </ul>
                                <div class="tab-content p-0">
                                    @foreach ($languages as $lang)
                                    
                                        <div class="tab-pane fade {{ $loop->index == 0 ? 'active show' : '' }}  "
                                            id="navs-{{ $lang->id }}" role="tabpanel">
                                            <div class="row">


                                                <div class="col-md-12 mt-3">
                                                    <label class="form-label mb-1"
                                                        for="content_{{ $lang->code }}"></label>
                                                    <textarea id="description_{{ $lang->code }}"
                                                        class="form-control editor_style_{{ $lang->code }}  @error('description_' . $lang->code) is-invalid @enderror"
                                                        name="description_{{ $lang->code }}">{{ old('description_' . $lang->code, \App\Http\Helpers\HelperTranslate::get_value($item, $lang->code, 'description')) }}</textarea>
                                                    @error('description_' . $lang->code)
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach


                                </div>
                            </div>
                        </div>
                        <div class="pt-4">
                            <button type="submit" class="btn btn-primary me-sm-3 me-1">{{ __('messages.Save') }}</button>
                            <button type="reset" class="btn btn-label-secondary">{{ __('messages.Cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    @include('admin.posts.script')
    @include('inc.editor')
@endsection
