<?php

namespace Database\Seeders;

use App\Enums\UserRoleEnum;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UsersTableseeder extends Seeder
{

    /**
     * Run the database seeds.
     */
    public function run(): void
    {



        $admin = User::create([
            "name" => "Nofal Seo",
            "email" => "demo@admin.com",
            "password" => bcrypt(123456789),
            "type" => UserRoleEnum::Admin,
        ]);



        foreach (UserRoleEnum::values_not_admin() as $value) {
            User::create([
                "name" =>  $value,
                "email" => "demo@" . $value . ".com",
                "password" => bcrypt(123456789),

                "type" => $value,
            ]);
        }











        $permissions = array_merge($this->admin_permissions());


        $permission_db = [];

        foreach ($permissions as $permission) {
            $permission_db[] = [
                "name" => $permission,
                "guard_name" => "web"
            ];
        }
        DB::table('permissions')->insert($permission_db);

        $admin->givePermissionTo($this->admin_permissions());
    }


    private function admin_permissions()
    {
        return  [
            "admins",



            "create_user",
            "show_user",
            "edit_user",
            "block_user",
            "delete_user",

            "create_device",
            "show_device",
            "edit_device",
            "delete_device",



            "create_input_general_analysis_and_vars",
            "show_input_general_analysis_and_vars",
            "edit_input_general_analysis_and_vars",
            "delete_input_general_analysis_and_vars",


            "create_group_general_analysis",
            "show_group_general_analysis",
            "edit_group_general_analysis",
            "delete_group_general_analysis",



            "create_type_test_group",
            "show_type_test_group",
            "edit_type_test_group",
            "delete_type_test_group",




            "catch_logs",
            "admin_logs",


            "setting_lang",


        ];
    }
}
