<?php

namespace Database\Seeders;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Models\Setting;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Cache;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {


        $settings =[





           [
            "name"=>"Host",
            "key"=>"smtp_host",
            "value"=>"sandbox.smtp.mailtrap.io",
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>"mailers.smtp.host",
            "list_values"=>null


           ],
           [
            "name"=>"Port",
            "key"=>"smtp_port",
            "value"=>"2525",
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"number",
            "validation"=>"required|in:25,465,587,2525",
            "config_name"=>"mailers.smtp.port",
            "list_values"=>null
           ],


           [
            "name"=>"Username",
            "key"=>"smtp_username",
            "value"=>"Username",
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>"mailers.smtp.username",
            "list_values"=>null
           ],

           [
            "name"=>"Password",
            "key"=>"smtp_password",
            "value"=>"password",
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>"mailers.smtp.password",
            "list_values"=>null
           ],

           [
            "name"=>"Encryption",
            "key"=>"smtp_encryption",
            "value"=>null,
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"text",
            "validation"=>"nullable|string|max:255",
            "config_name"=>"mailers.smtp.encryption",
            "list_values"=>null
           ],
           [
            "name"=>"From address",
            "key"=>"smtp_from_address",
            "value"=>"test@test.com",
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"email",
            "validation"=>"required|email|max:255",
            "config_name"=>null,
            "list_values"=>null

           ],

           [
            "name"=>"From name",
            "key"=>"smtp_from_name",
            "value"=>config('app.name'),
            "group"=>"smtp",
            "page"=>"SMTP",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>null,
            "list_values"=>null

           ],







           [
            "name"=>"Description ar",
            "key"=>"general_description_ar",
            "value"=>"منصة ThePen هي منصة خدمات تساعدك في الواجبات الدراسية والمشاريع الأكاديمية، من خلال فريق من الخبراء في مجالات متعددة يمكنهم مساعدة الطلاب في إنجاز مهامهم الأكاديمية بطريقة فعالة وموثوقة.",
            "group"=>"description",
            "page"=>"General",
            "type"=>"textarea",
            "validation"=>"required|string|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Description en",
            "key"=>"general_description_en",
            "value"=>"منصة ThePen هي منصة خدمات تساعدك في الواجبات الدراسية والمشاريع الأكاديمية، من خلال فريق من الخبراء في مجالات متعددة يمكنهم مساعدة الطلاب في إنجاز مهامهم الأكاديمية بطريقة فعالة وموثوقة.",
            "group"=>"description",
            "page"=>"General",
            "type"=>"textarea",
            "validation"=>"required|string|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],



           [
            "name"=>"Payment via",
            "key"=>"payment_via",
            "value"=>"paymob",
            "group"=>"Payment via",
            "page"=>"Payment",
            "type"=>"radio",
            "validation"=>"required|in:paytab,paymob,myfatoorah",
            "config_name"=>null,
            "list_values"=>"paytab,paymob,myfatoorah"
           ],





           [
            "name"=>"Iframe Id",
            "key"=>"payment_paymob_iframe_id",
            "value"=>"846348",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|integer",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Integration id",
            "key"=>"payment_paymob_integration_id",
            "value"=>"4575784",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|integer",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Tax",
            "key"=>"payment_paymob_tax",
            "value"=>"2",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|integer",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Currency",
            "key"=>"payment_paymob_currency",
            "value"=>"EGP",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:5",
            "config_name"=>null,
            "list_values"=>null

           ],



           [
            "name"=>"Website Redirect Success URL",
            "key"=>"payment_paymob_website_redirect_success_url",
            "value"=>"http://127.0.0.1:3000",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"url",
            "validation"=>"required|url",
            "config_name"=>null,
            "list_values"=>null
           ],



           [
            "name"=>"Website Redirect Fail URL",
            "key"=>"payment_paymob_website_redirect_fail_url",
            "value"=>"http://127.0.0.1:3000",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"url",
            "validation"=>"required|url",
            "config_name"=>null,
            "list_values"=>null
           ],



           [
            "name"=>"Secret key",
            "key"=>"payment_paymob_secret_key",
            "value"=>"egy_sk_test_c670c2fa07785934cb008f92770a600d91b80a64005a68461a8b66d2873e2df9",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Public Key",
            "key"=>"payment_paymob_public_key",
            "value"=>"egy_pk_test_DioQ0lSKufyfLk0jJ9nDNFSlYCzwqbgE",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Api Key",
            "key"=>"payment_paymob_api_key",
            "value"=>"ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0o5LmV5SmpiR0Z6Y3lJNklrMWxjbU5vWVc1MElpd2ljSEp2Wm1sc1pWOXdheUk2T1RjMk5EZ3lMQ0p1WVcxbElqb2lhVzVwZEdsaGJDSjkuZXFMOVJDd2UxcjBCVkxIZUNBekQwTzY5Z2VMS29Wa3lpZ0hfSDZHcVc2eGJXclRwanQ5WDBYQmhwQ1FLRk9udk5xR01EMERDaHZ0dFpleThiOEI2V0E=",
            "group"=>"Paymob",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],







           [
            "name"=>"Profile ID",
            "key"=>"payment_paytab_profile_id",
            "value"=>"135438",
            "group"=>"Paytab",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|integer",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Server key",
            "key"=>"payment_paytab_server_key",
            "value"=>"SZJ99MNJBL-JHN6T9226K-TTGNBDTDJ2",
            "group"=>"Paytab",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Currency",
            "key"=>"payment_paytab_currency",
            "value"=>"EGP",
            "group"=>"Paytab",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:3",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Region",
            "key"=>"payment_paytab_region",
            "value"=>"EGY",
            "group"=>"Paytab",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string|max:3",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Tax",
            "key"=>"payment_paytab_tax",
            "value"=>"2",
            "group"=>"Paytab",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|integer",
            "config_name"=>null,
            "list_values"=>null
           ],



           [
            "name"=>"Test Or Live",
            "key"=>"payment_myfatoorah_test_or_live",
            "value"=>"test",
            "group"=>"My Fatoorah",
            "page"=>"Payment",
            "type"=>"radio",
            "validation"=>"required|in:test,live",
            "config_name"=>null,
            "list_values"=>"test,live"
           ],







           [
            "name"=>"Region",
            "key"=>"payment_myfatoorah_country_iso",
            "value"=>"KWT",
            "group"=>"My Fatoorah",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Currency",
            "key"=>"payment_myfatoorah_currency",
            "value"=>"KWD",
            "group"=>"My Fatoorah",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|string",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Tax",
            "key"=>"payment_myfatoorah_tax",
            "value"=>"2",
            "group"=>"My Fatoorah",
            "page"=>"Payment",
            "type"=>"text",
            "validation"=>"required|intger",
            "config_name"=>null,
            "list_values"=>null
           ],


           [
            "name"=>"Api Key",
            "key"=>"payment_myfatoorah_api_key",
            "value"=>"rLtt6JWvbUHDDhsZnfpAhpYk4dxYDQkbcPTyGaKp2TYqQgG7FGZ5Th_WD53Oq8Ebz6A53njUoo1w3pjU1D4vs_ZMqFiz_j0urb_BH9Oq9VZoKFoJEDAbRZepGcQanImyYrry7Kt6MnMdgfG5jn4HngWoRdKduNNyP4kzcp3mRv7x00ahkm9LAK7ZRieg7k1PDAnBIOG3EyVSJ5kK4WLMvYr7sCwHbHcu4A5WwelxYK0GMJy37bNAarSJDFQsJ2ZvJjvMDmfWwDVFEVe_5tOomfVNt6bOg9mexbGjMrnHBnKnZR1vQbBtQieDlQepzTZMuQrSuKn-t5XZM7V6fCW7oP-uXGX-sMOajeX65JOf6XVpk29DP6ro8WTAflCDANC193yof8-f5_EYY-3hXhJj7RBXmizDpneEQDSaSz5sFk0sV5qPcARJ9zGG73vuGFyenjPPmtDtXtpx35A-BVcOSBYVIWe9kndG3nclfefjKEuZ3m4jL9Gg1h2JBvmXSMYiZtp9MR5I6pvbvylU_PP5xJFSjVTIz7IQSjcVGO41npnwIxRXNRxFOdIUHn0tjQ-7LwvEcTXyPsHXcMD8WtgBh-wxR8aKX7WPSsT1O8d8reb2aR7K3rkV3K82K_0OgawImEpwSvp9MNKynEAJQS6ZHe_J_l77652xwPNxMRTMASk1ZsJL",
            "group"=>"My Fatoorah",
            "page"=>"Payment",
            "type"=>"textarea",
            "validation"=>"required|string",
            "config_name"=>null,
            "list_values"=>null
           ],










           [
            "name"=>"Email",
            "key"=>"communication_email",
            "value"=>"pengroup@gmail.com",
            "group"=>"Contacts",
            "page"=>"Communication",
            "type"=>"email",
            "validation"=>"required|email|max:255",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Address",
            "key"=>"communication_address",
            "value"=>"مصر ,القاهرة",
            "group"=>"Contacts",
            "page"=>"Communication",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>null,
            "list_values"=>null
           ],
           [
            "name"=>"Mobile",
            "key"=>"communication_mobile",
            "value"=>"010",
            "group"=>"Contacts",
            "page"=>"Communication",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Facebook",
            "key"=>"communication_facebook",
            "value"=>"https://www.facebook.com",
            "group"=>"Social Media",
            "page"=>"Communication",
            "type"=>"url",
            "validation"=>"required|url|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],

           [
            "name"=>"Linkedin",
            "key"=>"communication_linkedin",
            "value"=>"https://www.linkedin.com",
            "group"=>"Social Media",
            "page"=>"Communication",
            "type"=>"url",
            "validation"=>"required|url|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],
           [
            "name"=>"Twitter",
            "key"=>"communication_twitter",
            "value"=>"https://x.com",
            "group"=>"Social Media",
            "page"=>"Communication",
            "type"=>"url",
            "validation"=>"required|url|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],
           [
            "name"=>"Telegram",
            "key"=>"communication_telegram",
            "value"=>"telegram",
            "group"=>"Social Media",
            "page"=>"Communication",
            "type"=>"text",
            "validation"=>"required|url|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],
           [
            "name"=>"Instagram",
            "key"=>"communication_instagram",
            "value"=>"https://www.instagram.com/",
            "group"=>"Social Media",
            "page"=>"Communication",
            "type"=>"url",
            "validation"=>"required|url|max:100000",
            "config_name"=>null,
            "list_values"=>null
           ],





           [
            "name"=>"ID",
            "key"=>"realtime_pusher_app_id",
            "value"=>"1823556",
            "group"=>"Pusher",
            "page"=>"Realtime",
            "type"=>"number",
            "validation"=>"required|integer",
            "config_name"=>'broadcasting.connections.pusher.app_id',
            "list_values"=>null
           ],


           [
            "name"=>"Key",
            "key"=>"realtime_pusher_app_key",
            "value"=>"1823556",
            "group"=>"Pusher",
            "page"=>"Realtime",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>'broadcasting.connections.pusher.key',
            "list_values"=>null
           ],


           [
            "name"=>"Secret",
            "key"=>"realtime_pusher_app_secret",
            "value"=>"1823556",
            "group"=>"Pusher",
            "page"=>"Realtime",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>'broadcasting.connections.pusher.secret',
            "list_values"=>null
           ],


           [
            "name"=>"Cluster",
            "key"=>"realtime_pusher_app_cluster",
            "value"=>"eu",
            "group"=>"Pusher",
            "page"=>"Realtime",
            "type"=>"text",
            "validation"=>"required|string|max:255",
            "config_name"=>'broadcasting.connections.pusher.options.cluster',
            "list_values"=>null
           ],


           [
            "name"=>"Server Key",
            "key"=>"realtime_fcm_server_key",
            "value"=>null,
            "group"=>"FCM",
            "page"=>"Realtime",
            "type"=>"text",
            "validation"=>"required|string|max:50000",
            "config_name"=>'services.fcm.key',
            "list_values"=>null
           ],


           [
            "name"=>"Max File Image ( MB )",
            "key"=>"files_size_max_file_image",
            "value"=>5,
            "group"=>"Size",
            "page"=>"Files",
            "type"=>"text",
            "validation"=>"required|integer|max:50000",
            "config_name"=>null,
            "list_values"=>null
           ],








        ];




        Cache::forget("app_settings");
        Cache::forget("app_settings_config");
        Setting::insert($settings);
    }
}
