<?php

namespace Database\Seeders;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Models\GeneralAnalysis;
use App\Models\GeneralAnalysisVariable;
use App\Models\Variable;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class GeneralAnalysisVariableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $general_analysis = GeneralAnalysis::pluck('id')->toArray();
        $variables = Variable::pluck('id')->toArray();

        $data = [];
        foreach ($variables as $variable) {
            foreach ($general_analysis as $analysis) {
                $data[] = [
                    'general_analysis_id' => $analysis,
                    'variable_id' => $variable,
                ];
            }
        }

        GeneralAnalysisVariable::insert($data);
    }
}
