<?php

namespace Database\Seeders;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\DeviceTypeEnum;
use App\Models\Device;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DeviceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = DeviceTypeEnum::values();

        $data=[];
        foreach($types as $type){
            for($i = 1 ; $i <= 10 ; $i++ ){

                $data[]=[
                    "name"=>"Device $i " . str_replace("_" , " " , $type),
                    "type"=>$type
                ];
            }
        }

        Device::insert($data);

    }
}
