<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('static_f_n_a_analyses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->date('date')->nullable();
            $table->longText('note')->nullable();
            $table->boolean('fna')->default(0)->nullable();
            $table->boolean('tesa')->default(0)->nullable();
            $table->boolean('tese')->default(0)->nullable();
            $table->string('sperm_concentration_left')->nullable();
            $table->string('sperm_concentration_right')->nullable();

            $table->string('progressive_motility_left')->nullable();
            $table->string('progressive_motility_right')->nullable();

            $table->string('non_progressive_motility_left')->nullable();
            $table->string('non_progressive_motility_right')->nullable();

            $table->string('total_motility_left')->nullable();
            $table->string('total_motility_right')->nullable();

            $table->string('immotile_sperm_left')->nullable();
            $table->string('immotile_sperm_right')->nullable();

            $table->string('sperm_morphology_left')->nullable();
            $table->string('sperm_morphology_right')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('static_f_n_a_analyses');
    }
};
