<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('static_s_f_a_analyses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->time('examination_time')->nullable();
            $table->time('collection_time')->nullable();
            $table->integer('abstinence_days')->nullable();
            $table->enum('evaluation' , ['good' , 'bad' , 'excellent'])->nullable();
            $table->string('concentration')->nullable();
            $table->decimal('progressive')->nullable();
            $table->string('non-progressive')->nullable();
            $table->string('abnormal_form')->nullable();
            $table->boolean('ivf_for_dna_fragmentation')->nullable();
            $table->decimal('ivf_for_percent')->nullable();
            $table->longText('ivf_for_note')->nullable();
            $table->boolean('ivf_for_fit_icsi')->default(0);
            $table->boolean('ivf_for_fit_iui')->default(0);
            $table->boolean('ivf_for_fit_pgd')->default(0);
            $table->boolean('ivf_for_fit_iui_xy')->default(0);
            $table->longText('note')->nullable();


            $table->string('volume')->nullable(); // Volume
            $table->string('color')->nullable(); // Color
            $table->string('viscosity')->nullable(); // Viscosity
            $table->string('liquefaction')->nullable(); // Liquefaction
            $table->string('reaction')->nullable(); // Reaction

            $table->string('total_sperm_count')->nullable(); // Total sperm count in ejaculate
            $table->string('sperm_concentration')->nullable(); // Sperm concentration (per ml)
            $table->string('progressive_motility')->nullable(); // Progressive motility (PR)%
            $table->string('non_progressive_motility')->nullable(); // Non-Progressive motility (NP)%
            $table->string('total_motility')->nullable(); // Total (PR+NP) motility %
            $table->string('immotile_sperm')->nullable(); // Immotile sperm %
            $table->string('sperm_morphology')->nullable(); // Sperm morphology (Abnormal form) %
            $table->string('round_cells')->nullable(); // Round cells
            $table->string('agglutination')->nullable(); // Agglutination


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('static_s_f_a_analyses');
    }
};
