<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('static_i_u_i_analyses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->time('examination_time')->nullable();
            $table->time('collection_time')->nullable();
            $table->integer('abstinence_days')->nullable();
            $table->enum('evaluation' , ['good' , 'bad' , 'excellent'])->nullable();



            $table->string('volume')->nullable();
            $table->string('color')->nullable();
            $table->string('viscosity')->nullable();
            $table->string('liquefaction')->nullable();
            $table->string('reaction')->nullable();
            // Columns repeated for 'before' and 'after'
            $table->string('total_sperm_count_before')->nullable();
            $table->string('total_sperm_count_after')->nullable();

            $table->string('sperm_concentration_before')->nullable();
            $table->string('sperm_concentration_after')->nullable();

            $table->string('progressive_motility_before')->nullable();
            $table->string('progressive_motility_after')->nullable();

            $table->string('non_progressive_motility_before')->nullable();
            $table->string('non_progressive_motility_after')->nullable();

            $table->string('total_motility_before')->nullable();
            $table->string('total_motility_after')->nullable();

            $table->string('immotile_sperm_before')->nullable();
            $table->string('immotile_sperm_after')->nullable();

            $table->string('sperm_morphology_before')->nullable();
            $table->string('sperm_morphology_after')->nullable();

            $table->string('round_cells_before')->nullable();
            $table->string('round_cells_after')->nullable();

            $table->string('agglutination_before')->nullable();
            $table->string('agglutination_after')->nullable();
            $table->longText('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('static_i_u_i_analyses');
    }
};
