<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('protocol_medications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('protocol_id')->constrained()->cascadeOnDelete();
            $table->foreignId('medication_id')->constrained()->cascadeOnDelete();
            $table->longText('report')->nullable();
            $table->string('dose')->nullable()->comment('الجرعة'); // خاص بالادوية
            $table->string('number_of_doses')->nullable()->comment('عدد الجرع'); // خاص بالادوية
            $table->time("time")->nullable(); // خاص بالابره التفيجيرية
            $table->date("day")->nullable(); // خاص بالابره التفيجيرية
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('protocol_medications');
    }
};
