<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('protocols', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->integer('duration_of_infertility')->unsigned(); // مدة العقم
            $table->integer('number_of_children')->unsigned()->default(0); // عدد الأطفال
            $table->integer('number_of_miscarriages')->unsigned()->default(0); // عدد مرات الاجهاض
            $table->integer('previous_ivf_trials')->unsigned()->default(0); // عدد المحاولات السابقة لعميات أطفال الانابيب
            $table->text('known_causes_of_infertility')->nullable(); // الأسباب المعروفة للعقم
            $table->string('female_factor')->nullable()->comment('FemaleFactorEnum class');
            $table->boolean('unexplained_infertility')->default(0); // عوامل غير معروفه
            $table->longText('report_female_factor')->nullable();
            $table->longText('report_male_factor')->nullable();
            $table->longText('report_other_factor')->nullable();
            $table->integer('cycle_day') ; // يوم الدورة
            $table->date('date');
            $table->string('protocol')->nullable()->comment('ProtocolTypeEnum   class');
            $table->longText('report_ultrasound')->nullable();
            $table->longText('report_laparoscopy')->nullable();
            $table->longText('report_hysteroscopy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('protocols');
    }
};
