<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('q_m_co2_and_n2_cylinder_gas_level_check_data', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('q_m_co2_and_n2_cylinder_gas_level_check_id');
            $table->foreign('q_m_co2_and_n2_cylinder_gas_level_check_id' , 'q_m_co2_and_n2_cylinder_gas_level_check_data')->references('id')->on('q_m_co2_and_n2_cylinder_gas_level_checks')->cascadeOnDelete();
            $table->dateTime('date_time');
            $table->string('cylinder_no');
            $table->decimal('co2_level', 5, 2);
            $table->decimal('n2_level', 5, 2);
            $table->string('check_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('q_m_co2_and_n2_cylinder_gas_level_check_data');
    }
};
