<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('q_m_micromanipulator_and_icsi_stations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('device_id')->constrained()->cascadeOnDelete();
          //  $table->string('id_or_name');
            $table->enum('laser_alignment_status', ['good', 'acceptable', 'poor']);
            $table->decimal('heating_stage_temperature', 5, 2);
            $table->enum('anti_vibration_tables_status', ['good', 'acceptable', 'poor']);
            $table->enum('electronic_systems_status', ['good', 'acceptable', 'poor']);
            $table->date('cleaning_date');
            $table->date('next_cleaning_date');
            $table->string('check_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('q_m_micromanipulator_and_icsi_stations');
    }
};
