<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('q_m_workstations_and_laminar_flow_cabinets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('device_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
           // $table->string('laminar_flow_id_or_name');
            $table->decimal('heating_stage_temperature', 10, 2);
            $table->date('filter_installation_date');
            $table->date('cleaning_date');
            $table->date('next_cleaning_date');
            $table->text('report');
            $table->enum('evaluation' ,['very_bad' , 'bad' , 'accepted' , 'good' ] );
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('q_m_workstations_and_laminar_flow_cabinets');
    }
};
