<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('q_m_incubator_quality_control_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('device_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->date('date');
           // $table->string('incubator_name');
            $table->decimal('temperature', 5, 2);
            $table->decimal('water_level', 5, 2);
            $table->decimal('co2_level', 5, 2);
            $table->decimal('o2_level', 5, 2);
            $table->decimal('n2_level', 5, 2);
            $table->decimal('humidity', 5, 2);
            $table->decimal('ph_of_culture_medium', 5, 2);
            $table->string('lot_number_culture_medium');
            $table->dateTime('uv_lamp_installation_date');
            $table->dateTime('hepa_filter_installation_date');
            $table->date('cleaning_date');
            $table->date('next_cleaning_date');
            $table->text('report')->nullable();
            $table->enum('evaluation' ,['very_bad' , 'bad' , 'accepted' , 'good' ] );
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('q_m_incubator_quality_control_logs');
    }
};
