<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cryopreservations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();
            $table->enum('type' , ['freezing' , 'thawing' , 'sperm']);
            $table->date('date');
            $table->enum('oocyte_or_embryo' , ['oocyte' , 'embryo'])->nullable()->comment('خاص بالاذابة والتجميد');
            $table->integer('number_oocyte_or_embryo')->nullable()->comment('خاص بالاذابة والتجميد');
            $table->integer('day')->nullable()->comment('خاص بالاذابة والتجميد');
            $table->integer('number_straw_or_straw_thawed');
            $table->integer('number_straw_remaining')->nullable()->comment('خاص بالاذابة والحيامن  فقط');
            $table->longText('degree')->nullable()->comment('خاص بالاذابة والتجميد');
            $table->longText('report');
            $table->string('location_tank')->nullable()->comment('خاص بالاذابة ');
            $table->string('location_canisters')->nullable()->comment('خاص بالاذابة ');
            $table->string('location_cryocane')->nullable()->comment('خاص بالاذابة ');
            $table->string('color_of_straw')->nullable()->comment('خاص بالاذابة والتجميد');
            $table->string('media')->nullable()->comment('خاص بالاذابة والتجميد');


            $table->integer('count')->nullable()->comment('خاص  بالحيامن');

            $table->enum('frozen_sample_type' , ['fna','tesa','tese','pesa','semen'])->nullable('خاص بالحيامن');
            $table->decimal('abnormal_form')->nullable('خاص بالحيامن');
            $table->string('did_freezing')->nullable('خاص بالحيامن');
            $table->decimal('total_motility_progressive')->nullable('خاص بالحيامن');
            $table->decimal('total_motility_non_progressive')->nullable('خاص بالحيامن');
            $table->decimal('total_motility_immotile')->nullable('خاص بالحيامن');

            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cryopreservations');
    }
};
