<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_group_step_six_thawings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->enum('oocyte_or_embryo' , ['oocyte' , 'embryo']);
            $table->integer('day');
            $table->integer('number_oocyte_or_embryo');
            $table->longText('degree');
            $table->integer('number_straw_thawed');
            $table->integer('number_straw_remaining');
            $table->string('color_of_straw');
            $table->string('media');
            $table->longText('report');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_group_step_six_thawings');
    }
};
