<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_group_step_fives', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->integer('day');
            $table->integer('count');
            $table->longText('report');
            $table->longText('transfer_evaluation');
            $table->enum("assisted_hatched" , ['yes' , 'no']);
            $table->enum("embryo_glue" , ['yes' , 'no']);
            $table->string('media');
            $table->enum('pregnancy_status' , ['pregnant','not_pregnant','miscarriage','not_returned'])->nullable();
            $table->enum('evaluation_et' ,['very_bad' , 'bad' , 'accepted' , 'good' ] )->nullable();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_group_step_fives');
    }
};
