<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_group_step_fours', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->integer('day');
            $table->integer('number_oocyte_fertilized')->nullable();
            $table->integer('abnormal_fertilized')->nullable();
            $table->integer('blastocyst')->nullable();
            $table->foreignId('user_id')->nullable()->comment('الاخصائى المسئول')->constrained()->cascadeOnDelete();
            $table->longText('report');
            $table->boolean("is_complete")->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_group_step_fours');
    }
};
