<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_group_step_threes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('analysis_patient_id')->constrained()->cascadeOnDelete();
            $table->integer('number_oocyte_injected');
            $table->time('time');
            $table->integer('m_1');
            $table->integer('m_2');
            $table->integer('g_v');
            $table->integer('degeneration_rate_after_icsi');
            $table->integer('abnormal');

            // options

            $table->boolean('option_giant')->default(0);
            $table->boolean('option_smal')->default(0);
            $table->boolean('option_oval')->default(0);
            $table->boolean('option_irregular')->default(0);
            $table->boolean('option_large_polar_bodies')->default(0);
            $table->boolean('option_fragmented_polar_bodies')->default(0);
            $table->boolean('option_multi_polar_bodies')->default(0);
            $table->boolean('option_wide_space')->default(0);
            $table->boolean('option_uneven_space')->default(0);
            $table->boolean('option_inclusions_in_the_space')->default(0);
            $table->boolean('option_thin_zone')->default(0);
            $table->boolean('option_thick_zona')->default(0);
            $table->boolean('option_hairy_brush_like')->default(0);
            $table->boolean('option_empty_zona')->default(0);
            $table->boolean('option_vacuolated')->default(0);
            $table->boolean('option_dark')->default(0);
            $table->boolean('option_granulation')->default(0);
            $table->boolean('option_blebs')->default(0);
            $table->boolean('option_refractile_bodies')->default(0);


            // evaluation oocyte
            $table->enum('evaluation_oocyte' ,['very_bad' , 'bad' , 'accepted' , 'good' ] );
            $table->longText("evaluation_oocyte_report");
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            //sperm source
            $table->boolean('sperm_source_ejaculate')->default(0);
            $table->boolean('sperm_source_fns')->default(0);
            $table->boolean('sperm_source_tese')->default(0);
            $table->boolean('sperm_source_tesa')->default(0);
            $table->boolean('sperm_source_frozen')->default(0);
            $table->string('count');
            $table->decimal('motility');
            $table->decimal('abnormal_form');


            //evaluation sperm
            $table->enum('evaluation_sperm' ,['very_bad' , 'bad' , 'accepted' , 'good' ] );
            $table->longText("evaluation_sperm_report");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_group_step_threes');
    }
};
