<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('analysis_patients', function (Blueprint $table) {
            $table->id();
            $table->enum('type'  , ['general' , 'test_group']);
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('doctor_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('general_analysis_id')->nullable()->constrained()->cascadeOnDelete();
            $table->date("date")->nullable();
            $table->time("time")->nullable();
            $table->boolean('is_sample_received')->default(0);
            $table->foreignId('type_test_group_id')->nullable()->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('analysis_patients');
    }
};
