<?php

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->string('name')->nullable();
            $table->integer('age')->nullable();
            $table->string('occupation')->comment('المهنة')->nullable();
            $table->decimal('height')->nullable();
            $table->string('mobile')->nullable();
            $table->string('place_of_residence')->nullable()->comment('محل السكن');
            $table->string('id_number')->nullable();
            $table->string('medical_file_number')->nullable();
            $table->string('date_of_visit')->nullable();
            $table->longText('medical_history')->nullable();



            // الطرف الاخر
            $table->string('other_name')->nullable();
            $table->integer('other_age')->nullable();
            $table->string('other_occupation')->comment('المهنة')->nullable();
            $table->decimal('other_height')->nullable();
            $table->string('other_mobile')->nullable();
            $table->string('other_place_of_residence')->comment('محل السكن')->nullable();
            $table->string('other_id_number')->nullable();
            $table->string('other_medical_file_number')->nullable();
            $table->string('other_date_of_visit')->nullable();
            $table->longText('other_medical_history')->nullable();
            $table->date('date_marriage')->nullable();
            $table->boolean('pregenant_status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};
