<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            $table->string('name')->nullable();
            $table->string('email')->unique()->nullable();
            $table->string('type')->comment('App\Enums\UserRoleEnum');
            $table->string('mobile')->nullable();
            $table->string('image')->nullable();
            $table->boolean('is_block')->default(0);
            $table->boolean('is_delete')->default(0);
            $table->integer('password_change_count')->default(0);
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string('lang')->default('ar');
            $table->decimal('rate',3,2)->nullable();
            $table->string('fcm_token')->nullable();
            $table->boolean('is_new_from_system')->default(0);

            $table->rememberToken();
             $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
