<?php

namespace App\Models;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Protocol extends Model
{
    use HasFactory;
    protected $guarded=['id'];

    public function analysis_patient(){
        return $this->belongsTo(AnalysisPatient::class);
    }

    public function male_factors(){
        return $this->hasMany(ProtocolMaleFactor::class);
    }
    public function medications(){
        return $this->hasMany(ProtocolMedication::class );
    }


    public function medications_ovarian_stimulation(){
        return $this->hasMany(ProtocolMedication::class)->whereHas('medication' , function($q){
            $q->where("type" , "ovarian_stimulation");
        });
    }
    public function medications_ovulation_trigger(){
        return $this->hasMany(ProtocolMedication::class)->whereHas('medication' , function($q){
            $q->where("type" , "ovulation_trigger");
        });
    }

    public function files_ultrasound(){
        return $this->hasMany(ProtocolReportFile::class)->where("type" , "ultrasound");
    }

    public function files_laparoscopy(){
        return $this->hasMany(ProtocolReportFile::class)->where("type" , "laparoscopy");
    }

    public function files_hysteroscopy(){
        return $this->hasMany(ProtocolReportFile::class)->where("type" , "hysteroscopy");
    }


}
