<?php

namespace App\Models;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    use HasFactory;
    protected $guarded=['id'];

    public function files(){
        return $this->hasMany(PatientFile::class)->where("to" , "patient");
    }

    public function other_files(){
        return $this->hasMany(PatientFile::class)->where("to" , "other");
    }

    public function last_analysis(){
        return $this->hasOne(AnalysisPatient::class)->orderBy('id' , 'desc');
    }
}
