<?php

namespace App\Models;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Carbon\Carbon;
use App\Enums\NotificationTypeEnum;
use App\Http\Helpers\HelperNotification;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Notification extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $casts = [

        //  "message"=>"array"
    ];

    protected $appends = ['icon', 'link', 'message', 'time_format','time_min'];


    public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function getIconAttribute()
    {
        return asset('notification_icons/' . NotificationTypeEnum::tryFrom($this->notification_type)->value . '.png');
    }


    public function from_user(){
        return $this->belongsTo(User::class,'from_user_id');
    }


    public function getLinkAttribute()
    {
        return  HelperNotification::get_notification_url($this->notification_type, $this->params);
    }





    public function getMessageAttribute()
    {
        $message_array = json_decode($this->attributes['message'], true);

        if (auth()->check()) {
            if (isset($message_array[auth()->user()->lang])) {
                return $message_array[auth()->user()->lang];
            }
        }



        $default_lang_app  = Language::where("is_default", true)->first();
        if (isset($message_array[$default_lang_app['code']])) {

            return  $message_array[$default_lang_app['code']];
        }


        $key_first = array_key_first($message_array);
        return  $message_array[$key_first];
    }

    public function getTimeFormatAttribute()
    {
        return Carbon::parse($this->created_at)->format('Y-m-d H:i:s');
    }

    public function getTimeMinAttribute()
    {
        Carbon::setLocale(app()->getLocale());
        $date = Carbon::parse($this->created_at);
        return $date->diffForHumans(null, ['syntax' => Carbon::DIFF_RELATIVE_TO_NOW]);
    }
}
