<?php

namespace App\Models;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneralAnalysis extends Model
{
    use HasFactory;
    protected $guarded=['id'];

    public function variables(){
        return $this->belongsToMany(Variable::class  , 'general_analysis_variables');
    }

    protected static function booted()
    {
        if( request()->is('admin*') || request()->is('home') ){
            static::addGlobalScope('notype', function (Builder $builder) {
                $builder->whereNull('type');
            });
        }

    }
}
