<?php

namespace App\Models;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class AnalysisPatient extends Model
{
    use HasFactory;
    protected $guarded=['id'];


    public function  patient(){
        return $this->belongsTo(Patient::class);
    }

    public function  doctor(){
        return $this->belongsTo(User::class , 'doctor_id');
    }

    public function general_analysis(){
        return $this->belongsTo(GeneralAnalysis::class , 'general_analysis_id');
    }


    public function report(){
        return $this->hasOne(ReportGeneralAnalysis::class, 'analysis_patient_id');
    }


    public function step_1(){
        return $this->hasOne(TestGroupStepOne::class);
    }

    public function step_2(){
        return $this->hasOne(TestGroupStepTwo::class);
    }

    public function step_3(){
        return $this->hasOne(TestGroupStepThree::class);
    }

    public function step_4_all(){
        return $this->hasMany(TestGroupStepFour::class);
    }
    public function step_4(){
        return $this->hasOne(TestGroupStepFour::class);
    }

    public function step_4_complete(){
        return $this->hasOne(TestGroupStepFour::class)->where("is_complete" , true);
    }


    public function step_4_day_1(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 1);
    }

    public function step_4_day_2(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 2);
    }


    public function step_4_day_3(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 3);
    }


    public function step_4_day_4(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 4);
    }


    public function step_4_day_5(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 5);
    }

    public function step_4_day_6(){
        return $this->hasOne(TestGroupStepFour::class)->where("day" , 6);
    }


    public function step_5(){
        return $this->hasOne(TestGroupStepFive::class);
    }

    public function step_6_freezings(){
        return $this->hasOne(TestGroupStepSixFreezing::class);
    }


    public function step_6_thawings(){
        return $this->hasOne(TestGroupStepSixThawing::class);
    }

    public function step_7(){
        return $this->hasOne(TestGroupStepSeven::class);
    }


    public function protocol(){
        return $this->hasOne(Protocol::class);
    }


    public function type_test_group(){
        return $this->belongsTo(TypeTestGroup::class);
    }





    public function iui(){
        return $this->hasOne(StaticIUIAnalysis::class);
    }

    public function fna(){
        return $this->hasOne(StaticFNAAnalysis::class);
    }

    public function sfa(){
        return $this->hasOne(StaticSFAAnalysis::class);
    }

    public function pgd(){
        return $this->hasOne(Pgd::class);
    }

    protected static function booted()
    {

        if( request()->is('admin*') || request()->is('home') ){
            static::addGlobalScope('notype', function (Builder $builder) {
                $builder->whereHas('general_analysis' ,  function($q){
                    $q->whereNull('type');
                });

            });
        }


    }





}
