<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserAuthResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id"=> (int)$this->id ,
            "type"=>$this->type,
            'name' => $this->name,
            "email"=>$this->email,
            "mobile"=>$this->mobile,
            'image' => $this->image  ? asset( $this->image) : asset('default-images/user-image.png'),
            "token"=>$this->token
        ];
    }
}
